/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.content.ContentResolver;
import android.content.res.Resources;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import android.util.Log;
import deviceinfo.mayur.medialibrary.R;
import deviceinfo.mayur.medialibrary.data.BucketHelper;
import deviceinfo.mayur.medialibrary.data.ChangeNotifier;
import deviceinfo.mayur.medialibrary.data.DataManager;
import deviceinfo.mayur.medialibrary.data.LocalImage;
import deviceinfo.mayur.medialibrary.data.LocalMediaItem;
import deviceinfo.mayur.medialibrary.data.LocalVideo;
import deviceinfo.mayur.medialibrary.data.MediaDataContext;
import deviceinfo.mayur.medialibrary.data.MediaItem;
import deviceinfo.mayur.medialibrary.data.MediaSet;
import deviceinfo.mayur.medialibrary.data.Path;
import deviceinfo.mayur.medialibrary.util.GalleryUtils;
import deviceinfo.mayur.medialibrary.util.MediaSetUtils;
import deviceinfo.mayur.medialibrary.util.Utils;
import java.io.File;
import java.util.ArrayList;

public class LocalAlbum
extends MediaSet {
    private static final String TAG = "LocalAlbum";
    private static final String[] COUNT_PROJECTION = new String[]{"count(*)"};
    private static final int INVALID_COUNT = -1;
    private final String mWhereClause;
    private final String mOrderClause;
    private final Uri mBaseUri;
    private final String[] mProjection;
    private final MediaDataContext mApplication;
    private final ContentResolver mResolver;
    private final int mBucketId;
    private final String mName;
    private final boolean mIsImage;
    private final ChangeNotifier mNotifier;
    private final Path mItemPath;
    private int mCachedCount = -1;

    public LocalAlbum(Path path, MediaDataContext application, int bucketId, boolean isImage, String name) {
        super(path, LocalAlbum.nextVersionNumber());
        this.mApplication = application;
        this.mResolver = application.getContentResolver();
        this.mBucketId = bucketId;
        this.mName = name;
        this.mIsImage = isImage;
        if (isImage) {
            this.mWhereClause = "bucket_id = ?";
            this.mOrderClause = "datetaken DESC, _id DESC";
            this.mBaseUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            this.mProjection = LocalImage.PROJECTION;
            this.mItemPath = LocalImage.ITEM_PATH;
        } else {
            this.mWhereClause = "bucket_id = ?";
            this.mOrderClause = "datetaken DESC, _id DESC";
            this.mBaseUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
            this.mProjection = LocalVideo.PROJECTION;
            this.mItemPath = LocalVideo.ITEM_PATH;
        }
        this.mNotifier = new ChangeNotifier((MediaSet)this, this.mBaseUri, application);
    }

    public LocalAlbum(Path path, MediaDataContext application, int bucketId, boolean isImage) {
        this(path, application, bucketId, isImage, BucketHelper.getBucketName(application.getContentResolver(), bucketId));
    }

    @Override
    public boolean isCameraRoll() {
        return this.mBucketId == MediaSetUtils.CAMERA_BUCKET_ID;
    }

    @Override
    public Uri getContentUri() {
        if (this.mIsImage) {
            return MediaStore.Images.Media.EXTERNAL_CONTENT_URI.buildUpon().appendQueryParameter("bucketId", String.valueOf(this.mBucketId)).build();
        }
        return MediaStore.Video.Media.EXTERNAL_CONTENT_URI.buildUpon().appendQueryParameter("bucketId", String.valueOf(this.mBucketId)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<MediaItem> getMediaItem(int start, int count) {
        DataManager dataManager = this.mApplication.getDataManager();
        Uri uri = this.mBaseUri.buildUpon().appendQueryParameter("limit", start + "," + count).build();
        ArrayList<MediaItem> list = new ArrayList<MediaItem>();
        GalleryUtils.assertNotInRenderThread();
        Cursor cursor = this.mResolver.query(uri, this.mProjection, this.mWhereClause, new String[]{String.valueOf(this.mBucketId)}, this.mOrderClause);
        if (cursor == null) {
            Log.w((String)TAG, (String)("query fail: " + uri));
            return list;
        }
        try {
            while (cursor.moveToNext()) {
                int id = cursor.getInt(0);
                Path childPath = this.mItemPath.getChild(id);
                MediaItem item = LocalAlbum.loadOrUpdateItem(childPath, cursor, dataManager, this.mApplication, this.mIsImage);
                list.add(item);
            }
        }
        finally {
            cursor.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MediaItem loadOrUpdateItem(Path path, Cursor cursor, DataManager dataManager, MediaDataContext app, boolean isImage) {
        Object object = DataManager.LOCK;
        synchronized (object) {
            LocalMediaItem item = (LocalMediaItem)dataManager.peekMediaObject(path);
            if (item == null) {
                item = isImage ? new LocalImage(path, app, cursor) : new LocalVideo(path, app, cursor);
            } else {
                item.updateContent(cursor);
            }
            return item;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaItem[] getMediaItemById(MediaDataContext application, boolean isImage, ArrayList<Integer> ids) {
        Path itemPath;
        String[] projection;
        Uri baseUri;
        MediaItem[] result = new MediaItem[ids.size()];
        if (ids.isEmpty()) {
            return result;
        }
        int idLow = ids.get(0);
        int idHigh = ids.get(ids.size() - 1);
        if (isImage) {
            baseUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            projection = LocalImage.PROJECTION;
            itemPath = LocalImage.ITEM_PATH;
        } else {
            baseUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
            projection = LocalVideo.PROJECTION;
            itemPath = LocalVideo.ITEM_PATH;
        }
        ContentResolver resolver = application.getContentResolver();
        DataManager dataManager = application.getDataManager();
        Cursor cursor = resolver.query(baseUri, projection, "_id BETWEEN ? AND ?", new String[]{String.valueOf(idLow), String.valueOf(idHigh)}, "_id");
        if (cursor == null) {
            Log.w((String)TAG, (String)("query fail" + baseUri));
            return result;
        }
        try {
            int n = ids.size();
            int i = 0;
            while (i < n && cursor.moveToNext()) {
                MediaItem item;
                int id = cursor.getInt(0);
                if (ids.get(i) > id) continue;
                while (ids.get(i) < id) {
                    if (++i < n) continue;
                    MediaItem[] mediaItemArray = result;
                    return mediaItemArray;
                }
                Path childPath = itemPath.getChild(id);
                result[i] = item = LocalAlbum.loadOrUpdateItem(childPath, cursor, dataManager, application, isImage);
                ++i;
            }
            MediaItem[] mediaItemArray = result;
            return mediaItemArray;
        }
        finally {
            cursor.close();
        }
    }

    public static Cursor getItemCursor(ContentResolver resolver, Uri uri, String[] projection, int id) {
        return resolver.query(uri, projection, "_id=?", new String[]{String.valueOf(id)}, null);
    }

    @Override
    public int getMediaItemCount() {
        if (this.mCachedCount == -1) {
            Cursor cursor = this.mResolver.query(this.mBaseUri, COUNT_PROJECTION, this.mWhereClause, new String[]{String.valueOf(this.mBucketId)}, null);
            if (cursor == null) {
                Log.w((String)TAG, (String)"query fail");
                return 0;
            }
            try {
                Utils.assertTrue(cursor.moveToNext());
                this.mCachedCount = cursor.getInt(0);
            }
            finally {
                cursor.close();
            }
        }
        return this.mCachedCount;
    }

    @Override
    public String getName() {
        return LocalAlbum.getLocalizedName(this.mApplication.getContext().getResources(), this.mBucketId, this.mName);
    }

    @Override
    public long reload() {
        if (this.mNotifier.isDirty()) {
            this.mDataVersion = LocalAlbum.nextVersionNumber();
            this.mCachedCount = -1;
        }
        return this.mDataVersion;
    }

    @Override
    public int getSupportedOperations() {
        return 1029;
    }

    @Override
    public void delete() {
        GalleryUtils.assertNotInRenderThread();
        this.mResolver.delete(this.mBaseUri, this.mWhereClause, new String[]{String.valueOf(this.mBucketId)});
    }

    @Override
    public boolean isLeafAlbum() {
        return true;
    }

    public static String getLocalizedName(Resources res, int bucketId, String name) {
        if (bucketId == MediaSetUtils.CAMERA_BUCKET_ID) {
            return res.getString(R.string.folder_camera);
        }
        if (bucketId == MediaSetUtils.DOWNLOAD_BUCKET_ID) {
            return res.getString(R.string.folder_download);
        }
        if (bucketId == MediaSetUtils.IMPORTED_BUCKET_ID) {
            return res.getString(R.string.folder_imported);
        }
        if (bucketId == MediaSetUtils.SNAPSHOT_BUCKET_ID) {
            return res.getString(R.string.folder_screenshot);
        }
        if (bucketId == MediaSetUtils.EDITED_ONLINE_PHOTOS_BUCKET_ID) {
            return res.getString(R.string.folder_edited_online_photos);
        }
        return name;
    }

    public static String getRelativePath(int bucketId) {
        String relativePath = "/";
        if (bucketId == MediaSetUtils.CAMERA_BUCKET_ID) {
            relativePath = relativePath + "DCIM/Camera";
        } else if (bucketId == MediaSetUtils.DOWNLOAD_BUCKET_ID) {
            relativePath = relativePath + "download";
        } else if (bucketId == MediaSetUtils.IMPORTED_BUCKET_ID) {
            relativePath = relativePath + "Imported";
        } else if (bucketId == MediaSetUtils.SNAPSHOT_BUCKET_ID) {
            relativePath = relativePath + "Pictures/Screenshots";
        } else if (bucketId == MediaSetUtils.EDITED_ONLINE_PHOTOS_BUCKET_ID) {
            relativePath = relativePath + "EditedOnlinePhotos";
        } else {
            File extStorage = Environment.getExternalStorageDirectory();
            String path = GalleryUtils.searchDirForPath(extStorage, bucketId);
            if (path == null) {
                Log.w((String)TAG, (String)("Relative path for bucket id: " + bucketId + " is not found."));
                relativePath = null;
            } else {
                relativePath = path.substring(extStorage.getAbsolutePath().length());
            }
        }
        return relativePath;
    }
}

