/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.net.Uri;
import android.os.Handler;
import android.provider.MediaStore;
import deviceinfo.mayur.medialibrary.R;
import deviceinfo.mayur.medialibrary.data.BucketHelper;
import deviceinfo.mayur.medialibrary.data.ChangeNotifier;
import deviceinfo.mayur.medialibrary.data.DataManager;
import deviceinfo.mayur.medialibrary.data.LocalAlbum;
import deviceinfo.mayur.medialibrary.data.LocalMergeAlbum;
import deviceinfo.mayur.medialibrary.data.MediaDataContext;
import deviceinfo.mayur.medialibrary.data.MediaItem;
import deviceinfo.mayur.medialibrary.data.MediaObject;
import deviceinfo.mayur.medialibrary.data.MediaSet;
import deviceinfo.mayur.medialibrary.data.Path;
import deviceinfo.mayur.medialibrary.util.Future;
import deviceinfo.mayur.medialibrary.util.FutureListener;
import deviceinfo.mayur.medialibrary.util.MediaSetUtils;
import deviceinfo.mayur.medialibrary.util.ThreadPool;
import java.util.ArrayList;
import java.util.Comparator;

public class LocalAlbumSet
extends MediaSet
implements FutureListener<ArrayList<MediaSet>> {
    private static final String TAG = "LocalAlbumSet";
    public static final Path PATH_ALL = Path.fromString("/local/all");
    public static final Path PATH_IMAGE = Path.fromString("/local/image");
    public static final Path PATH_VIDEO = Path.fromString("/local/video");
    private static final Uri[] mWatchUris = new Uri[]{MediaStore.Images.Media.EXTERNAL_CONTENT_URI, MediaStore.Video.Media.EXTERNAL_CONTENT_URI};
    private final MediaDataContext mApplication;
    private final int mType;
    private ArrayList<MediaSet> mAlbums = new ArrayList();
    private final ChangeNotifier mNotifier;
    private final String mName;
    private final Handler mHandler;
    private boolean mIsLoading;
    private Future<ArrayList<MediaSet>> mLoadTask;
    private ArrayList<MediaSet> mLoadBuffer;

    public LocalAlbumSet(Path path, MediaDataContext application) {
        super(path, LocalAlbumSet.nextVersionNumber());
        this.mApplication = application;
        this.mHandler = new Handler(application.getMainLooper());
        this.mType = LocalAlbumSet.getTypeFromPath(path);
        this.mNotifier = new ChangeNotifier((MediaSet)this, mWatchUris, application);
        this.mName = application.getContext().getResources().getString(R.string.set_label_local_albums);
    }

    private static int getTypeFromPath(Path path) {
        String[] name = path.split();
        if (name.length < 2) {
            throw new IllegalArgumentException(path.toString());
        }
        return LocalAlbumSet.getTypeFromString(name[1]);
    }

    @Override
    public MediaSet getSubMediaSet(int index) {
        return this.mAlbums.get(index);
    }

    @Override
    public int getSubMediaSetCount() {
        return this.mAlbums.size();
    }

    @Override
    public String getName() {
        return this.mName;
    }

    private static int findBucket(BucketHelper.BucketEntry[] entries, int bucketId) {
        int n = entries.length;
        for (int i = 0; i < n; ++i) {
            if (entries[i].bucketId != bucketId) continue;
            return i;
        }
        return -1;
    }

    private MediaSet getLocalAlbum(DataManager manager, int type, Path parent, int id, String name) {
        Object object = DataManager.LOCK;
        synchronized (object) {
            Path path = parent.getChild(id);
            MediaObject object2 = manager.peekMediaObject(path);
            if (object2 != null) {
                return (MediaSet)object2;
            }
            switch (type) {
                case 2: {
                    return new LocalAlbum(path, this.mApplication, id, true, name);
                }
                case 4: {
                    return new LocalAlbum(path, this.mApplication, id, false, name);
                }
                case 6: {
                    Comparator<MediaItem> comp = DataManager.sDateTakenComparator;
                    return new LocalMergeAlbum(path, comp, new MediaSet[]{this.getLocalAlbum(manager, 2, PATH_IMAGE, id, name), this.getLocalAlbum(manager, 4, PATH_VIDEO, id, name)}, id);
                }
            }
            throw new IllegalArgumentException(String.valueOf(type));
        }
    }

    @Override
    public synchronized boolean isLoading() {
        return this.mIsLoading;
    }

    @Override
    public synchronized long reload() {
        if (this.mNotifier.isDirty()) {
            if (this.mLoadTask != null) {
                this.mLoadTask.cancel();
            }
            this.mIsLoading = true;
            this.mLoadTask = this.mApplication.getThreadPool().submit(new AlbumsLoader(), this);
        }
        if (this.mLoadBuffer != null) {
            this.mAlbums = this.mLoadBuffer;
            this.mLoadBuffer = null;
            for (MediaSet album : this.mAlbums) {
                album.reload();
            }
            this.mDataVersion = LocalAlbumSet.nextVersionNumber();
        }
        return this.mDataVersion;
    }

    @Override
    public synchronized void onFutureDone(Future<ArrayList<MediaSet>> future) {
        if (this.mLoadTask != future) {
            return;
        }
        this.mLoadBuffer = future.get();
        this.mIsLoading = false;
        if (this.mLoadBuffer == null) {
            this.mLoadBuffer = new ArrayList();
        }
        this.mAlbums = this.mLoadBuffer;
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                LocalAlbumSet.this.notifyContentChanged();
            }
        });
    }

    void fakeChange() {
        this.mNotifier.fakeChange();
    }

    private static <T> void circularShiftRight(T[] array, int i, int j) {
        T temp = array[j];
        for (int k = j; k > i; --k) {
            array[k] = array[k - 1];
        }
        array[i] = temp;
    }

    private class AlbumsLoader
    implements ThreadPool.Job<ArrayList<MediaSet>> {
        private AlbumsLoader() {
        }

        @Override
        public ArrayList<MediaSet> run(ThreadPool.JobContext jc) {
            Object[] entries = BucketHelper.loadBucketEntries(jc, LocalAlbumSet.this.mApplication.getContentResolver(), LocalAlbumSet.this.mType);
            if (jc.isCancelled()) {
                return null;
            }
            int offset = 0;
            int index = LocalAlbumSet.findBucket((BucketHelper.BucketEntry[])entries, MediaSetUtils.CAMERA_BUCKET_ID);
            if (index != -1) {
                LocalAlbumSet.circularShiftRight(entries, offset++, index);
            }
            if ((index = LocalAlbumSet.findBucket((BucketHelper.BucketEntry[])entries, MediaSetUtils.DOWNLOAD_BUCKET_ID)) != -1) {
                LocalAlbumSet.circularShiftRight(entries, offset++, index);
            }
            ArrayList<MediaSet> albums = new ArrayList<MediaSet>();
            DataManager dataManager = LocalAlbumSet.this.mApplication.getDataManager();
            for (Object entry : entries) {
                MediaSet album = LocalAlbumSet.this.getLocalAlbum(dataManager, LocalAlbumSet.this.mType, LocalAlbumSet.this.mPath, ((BucketHelper.BucketEntry)entry).bucketId, ((BucketHelper.BucketEntry)entry).bucketName);
                albums.add(album);
            }
            return albums;
        }
    }
}

