/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.media.ExifInterface;
import android.net.Uri;
import android.provider.MediaStore;
import android.util.Log;
import deviceinfo.mayur.medialibrary.data.DecodeUtils;
import deviceinfo.mayur.medialibrary.data.Face;
import deviceinfo.mayur.medialibrary.data.ImageCacheRequest;
import deviceinfo.mayur.medialibrary.data.LocalAlbum;
import deviceinfo.mayur.medialibrary.data.LocalMediaItem;
import deviceinfo.mayur.medialibrary.data.MediaDataContext;
import deviceinfo.mayur.medialibrary.data.MediaDetails;
import deviceinfo.mayur.medialibrary.data.MediaItem;
import deviceinfo.mayur.medialibrary.data.Path;
import deviceinfo.mayur.medialibrary.util.ApiHelper;
import deviceinfo.mayur.medialibrary.util.BitmapUtils;
import deviceinfo.mayur.medialibrary.util.GalleryUtils;
import deviceinfo.mayur.medialibrary.util.ThreadPool;
import deviceinfo.mayur.medialibrary.util.UpdateHelper;
import java.io.File;
import java.io.IOException;

public class LocalImage
extends LocalMediaItem {
    private static final String TAG = "LocalImage";
    private Face[] mFaces;
    static final Path ITEM_PATH = Path.fromString("/local/image/item");
    private static final int INDEX_ID = 0;
    private static final int INDEX_CAPTION = 1;
    private static final int INDEX_MIME_TYPE = 2;
    private static final int INDEX_LATITUDE = 3;
    private static final int INDEX_LONGITUDE = 4;
    private static final int INDEX_DATE_TAKEN = 5;
    private static final int INDEX_DATE_ADDED = 6;
    private static final int INDEX_DATE_MODIFIED = 7;
    private static final int INDEX_DATA = 8;
    private static final int INDEX_ORIENTATION = 9;
    private static final int INDEX_BUCKET_ID = 10;
    private static final int INDEX_SIZE = 11;
    private static final int INDEX_WIDTH = 12;
    private static final int INDEX_HEIGHT = 13;
    static final String[] PROJECTION = new String[]{"_id", "title", "mime_type", "latitude", "longitude", "datetaken", "date_added", "date_modified", "_data", "orientation", "bucket_id", "_size", "0", "0"};
    private final MediaDataContext mApplication;
    public int rotation;

    @TargetApi(value=16)
    private static void updateWidthAndHeightProjection() {
        if (ApiHelper.HAS_MEDIA_COLUMNS_WIDTH_AND_HEIGHT) {
            LocalImage.PROJECTION[12] = "width";
            LocalImage.PROJECTION[13] = "height";
        }
    }

    public LocalImage(Path path, MediaDataContext application, Cursor cursor) {
        super(path, LocalImage.nextVersionNumber());
        this.mFaces = null;
        this.mApplication = application;
        this.loadFromCursor(cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalImage(Path path, MediaDataContext application, int id) {
        block5: {
            super(path, LocalImage.nextVersionNumber());
            this.mFaces = null;
            this.mApplication = application;
            ContentResolver resolver = this.mApplication.getContentResolver();
            Uri uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            Cursor cursor = LocalAlbum.getItemCursor(resolver, uri, PROJECTION, id);
            if (cursor == null) {
                throw new RuntimeException("cannot get cursor for: " + path);
            }
            try {
                if (cursor.moveToNext()) {
                    this.loadFromCursor(cursor);
                    break block5;
                }
                throw new RuntimeException("cannot find data for: " + path);
            }
            finally {
                cursor.close();
            }
        }
    }

    private void loadFromCursor(Cursor cursor) {
        this.id = cursor.getInt(0);
        this.caption = cursor.getString(1);
        this.mimeType = cursor.getString(2);
        this.latitude = cursor.getDouble(3);
        this.longitude = cursor.getDouble(4);
        this.dateTakenInMs = cursor.getLong(5);
        this.dateAddedInSec = cursor.getLong(6);
        this.dateModifiedInSec = cursor.getLong(7);
        this.filePath = cursor.getString(8);
        this.rotation = cursor.getInt(9);
        this.bucketId = cursor.getInt(10);
        this.fileSize = cursor.getLong(11);
        this.width = cursor.getInt(12);
        this.height = cursor.getInt(13);
    }

    @Override
    protected boolean updateFromCursor(Cursor cursor) {
        UpdateHelper uh = new UpdateHelper();
        this.id = uh.update(this.id, cursor.getInt(0));
        this.caption = uh.update(this.caption, cursor.getString(1));
        this.mimeType = uh.update(this.mimeType, cursor.getString(2));
        this.latitude = uh.update(this.latitude, cursor.getDouble(3));
        this.longitude = uh.update(this.longitude, cursor.getDouble(4));
        this.dateTakenInMs = uh.update(this.dateTakenInMs, cursor.getLong(5));
        this.dateAddedInSec = uh.update(this.dateAddedInSec, cursor.getLong(6));
        this.dateModifiedInSec = uh.update(this.dateModifiedInSec, cursor.getLong(7));
        this.filePath = uh.update(this.filePath, cursor.getString(8));
        this.rotation = uh.update(this.rotation, cursor.getInt(9));
        this.bucketId = uh.update(this.bucketId, cursor.getInt(10));
        this.fileSize = uh.update(this.fileSize, cursor.getLong(11));
        this.width = uh.update(this.width, cursor.getInt(12));
        this.height = uh.update(this.height, cursor.getInt(13));
        return uh.isUpdated();
    }

    @Override
    public ThreadPool.Job<BitmapRegionDecoder> requestLargeImage() {
        return null;
    }

    @Override
    public ThreadPool.Job<Bitmap> requestImage(int type) {
        return new LocalImageRequest(this.mApplication, this.mPath, this.dateModifiedInSec, type, this.filePath);
    }

    @Override
    public int getSupportedOperations() {
        int operation = 1069;
        if (BitmapUtils.isSupportedByRegionDecoder(this.mimeType)) {
            operation |= 0x240;
        }
        if (BitmapUtils.isRotationSupported(this.mimeType)) {
            operation |= 2;
        }
        if (GalleryUtils.isValidLocation(this.latitude, this.longitude)) {
            operation |= 0x10;
        }
        return operation;
    }

    @Override
    public void delete() {
        GalleryUtils.assertNotInRenderThread();
        Uri baseUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        ContentResolver contentResolver = this.mApplication.getContentResolver();
        contentResolver.delete(baseUri, "_id=?", new String[]{String.valueOf(this.id)});
    }

    @Override
    public void rotate(int degrees) throws Exception {
        GalleryUtils.assertNotInRenderThread();
        Uri baseUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        ContentValues values = new ContentValues();
        int rotation = (this.rotation + degrees) % 360;
        if (rotation < 0) {
            rotation += 360;
        }
        if (this.mimeType.equalsIgnoreCase("image/jpeg")) {
            ExifInterface exifInterface = new ExifInterface(this.filePath);
            exifInterface.setAttribute("Orientation", String.valueOf(rotation));
            exifInterface.saveAttributes();
            this.fileSize = new File(this.filePath).length();
            values.put("_size", Long.valueOf(this.fileSize));
        }
        values.put("orientation", Integer.valueOf(rotation));
        this.mApplication.getContentResolver().update(baseUri, values, "_id=?", new String[]{String.valueOf(this.id)});
    }

    @Override
    public Uri getContentUri() {
        Uri baseUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        return baseUri.buildUpon().appendPath(String.valueOf(this.id)).build();
    }

    @Override
    public int getMediaType() {
        return 2;
    }

    @Override
    public MediaDetails getDetails() {
        MediaDetails details = super.getDetails();
        details.addDetail(7, this.rotation);
        if ("image/jpeg".equals(this.mimeType)) {
            MediaDetails.extractExifInfo(details, this.filePath);
        }
        return details;
    }

    @Override
    public int getRotation() {
        return this.rotation;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public Face[] getFaces() {
        return null;
    }

    static {
        LocalImage.updateWidthAndHeightProjection();
    }

    public class LocalImageRequest
    extends ImageCacheRequest {
        private String mLocalFilePath;

        LocalImageRequest(MediaDataContext application, Path path, long timeModified, int type, String localFilePath) {
            super(application, path, timeModified, type, MediaItem.getTargetSize(type));
            this.mLocalFilePath = localFilePath;
        }

        @Override
        public Bitmap onDecodeOriginal(ThreadPool.JobContext jc, int type) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inPreferredConfig = Bitmap.Config.ARGB_8888;
            int targetSize = MediaItem.getTargetSize(type);
            if (type == 2) {
                Bitmap bitmap;
                byte[] thumbData = null;
                try {
                    ExifInterface exif = new ExifInterface(this.mLocalFilePath);
                    thumbData = exif.getThumbnail();
                }
                catch (IOException e) {
                    Log.w((String)LocalImage.TAG, (String)("failed to find file to read thumbnail: " + this.mLocalFilePath));
                }
                if (thumbData != null && (bitmap = DecodeUtils.decodeIfBigEnough(jc, thumbData, options, targetSize)) != null) {
                    return bitmap;
                }
            }
            return DecodeUtils.decodeThumbnail(jc, this.mLocalFilePath, options, targetSize, type);
        }

        @Override
        public Bitmap beforeReturningBitmap(Bitmap bitmap) {
            return bitmap;
        }
    }
}

