/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.database.Cursor;
import deviceinfo.mayur.medialibrary.data.MediaDetails;
import deviceinfo.mayur.medialibrary.data.MediaItem;
import deviceinfo.mayur.medialibrary.data.Path;
import deviceinfo.mayur.medialibrary.util.GalleryUtils;
import java.text.DateFormat;
import java.util.Date;

public abstract class LocalMediaItem
extends MediaItem {
    private static final String TAG = "LocalMediaItem";
    public int id;
    public String caption;
    public String mimeType;
    public long fileSize;
    public double latitude = 0.0;
    public double longitude = 0.0;
    public long dateTakenInMs;
    public long dateAddedInSec;
    public long dateModifiedInSec;
    public String filePath;
    public int bucketId;
    public int width;
    public int height;

    public LocalMediaItem(Path path, long version) {
        super(path, version);
    }

    @Override
    public long getDateInMs() {
        return this.dateTakenInMs;
    }

    @Override
    public String getName() {
        return this.caption;
    }

    @Override
    public void getLatLong(double[] latLong) {
        latLong[0] = this.latitude;
        latLong[1] = this.longitude;
    }

    protected abstract boolean updateFromCursor(Cursor var1);

    public int getBucketId() {
        return this.bucketId;
    }

    protected void updateContent(Cursor cursor) {
        if (this.updateFromCursor(cursor)) {
            this.mDataVersion = LocalMediaItem.nextVersionNumber();
        }
    }

    @Override
    public MediaDetails getDetails() {
        MediaDetails details = super.getDetails();
        details.addDetail(200, this.filePath);
        details.addDetail(1, this.caption);
        DateFormat formater = DateFormat.getDateTimeInstance();
        details.addDetail(3, formater.format(new Date(this.dateModifiedInSec * 1000L)));
        details.addDetail(5, this.width);
        details.addDetail(6, this.height);
        if (GalleryUtils.isValidLocation(this.latitude, this.longitude)) {
            details.addDetail(4, new double[]{this.latitude, this.longitude});
        }
        if (this.fileSize > 0L) {
            details.addDetail(10, this.fileSize);
        }
        return details;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public long getSize() {
        return this.fileSize;
    }
}

