/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.net.Uri;
import android.provider.MediaStore;
import deviceinfo.mayur.medialibrary.data.ContentListener;
import deviceinfo.mayur.medialibrary.data.MediaItem;
import deviceinfo.mayur.medialibrary.data.MediaSet;
import deviceinfo.mayur.medialibrary.data.Path;
import deviceinfo.mayur.medialibrary.util.ApiHelper;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;

public class LocalMergeAlbum
extends MediaSet
implements ContentListener {
    private static final String TAG = "LocalMergeAlbum";
    private static final int PAGE_SIZE = 64;
    private final Comparator<MediaItem> mComparator;
    private final MediaSet[] mSources;
    private FetchCache[] mFetcher;
    private int mSupportedOperation;
    private int mBucketId;
    private TreeMap<Integer, int[]> mIndex = new TreeMap();

    public LocalMergeAlbum(Path path, Comparator<MediaItem> comparator, MediaSet[] sources, int bucketId) {
        super(path, -1L);
        this.mComparator = comparator;
        this.mSources = sources;
        this.mBucketId = bucketId;
        for (MediaSet set : this.mSources) {
            set.addContentListener(this);
        }
        this.reload();
    }

    @Override
    public boolean isCameraRoll() {
        if (this.mSources.length == 0) {
            return false;
        }
        for (MediaSet set : this.mSources) {
            if (set.isCameraRoll()) continue;
            return false;
        }
        return true;
    }

    private void updateData() {
        ArrayList matches = new ArrayList();
        int supported = this.mSources.length == 0 ? 0 : -1;
        this.mFetcher = new FetchCache[this.mSources.length];
        int n = this.mSources.length;
        for (int i = 0; i < n; ++i) {
            this.mFetcher[i] = new FetchCache(this.mSources[i]);
            supported &= this.mSources[i].getSupportedOperations();
        }
        this.mSupportedOperation = supported;
        this.mIndex.clear();
        this.mIndex.put(0, new int[this.mSources.length]);
    }

    private void invalidateCache() {
        int n = this.mSources.length;
        for (int i = 0; i < n; ++i) {
            this.mFetcher[i].invalidate();
        }
        this.mIndex.clear();
        this.mIndex.put(0, new int[this.mSources.length]);
    }

    @Override
    public Uri getContentUri() {
        String bucketId = String.valueOf(this.mBucketId);
        if (ApiHelper.HAS_MEDIA_PROVIDER_FILES_TABLE) {
            return MediaStore.Files.getContentUri((String)"external").buildUpon().appendQueryParameter("bucketId", bucketId).build();
        }
        return MediaStore.Images.Media.EXTERNAL_CONTENT_URI.buildUpon().appendQueryParameter("bucketId", bucketId).build();
    }

    @Override
    public String getName() {
        return this.mSources.length == 0 ? "" : this.mSources[0].getName();
    }

    @Override
    public int getMediaItemCount() {
        return this.getTotalMediaItemCount();
    }

    @Override
    public ArrayList<MediaItem> getMediaItem(int start, int count) {
        SortedMap<Integer, int[]> head = this.mIndex.headMap(start + 1);
        int markPos = head.lastKey();
        int[] subPos = (int[])((int[])head.get(markPos)).clone();
        MediaItem[] slot = new MediaItem[this.mSources.length];
        int size = this.mSources.length;
        for (int i = 0; i < size; ++i) {
            slot[i] = this.mFetcher[i].getItem(subPos[i]);
        }
        ArrayList<MediaItem> result = new ArrayList<MediaItem>();
        for (int i = markPos; i < start + count; ++i) {
            int k = -1;
            for (int j = 0; j < size; ++j) {
                if (slot[j] == null || k != -1 && this.mComparator.compare(slot[j], slot[k]) >= 0) continue;
                k = j;
            }
            if (k == -1) break;
            int n = k;
            subPos[n] = subPos[n] + 1;
            if (i >= start) {
                result.add(slot[k]);
            }
            slot[k] = this.mFetcher[k].getItem(subPos[k]);
            if ((i + 1) % 64 != 0) continue;
            this.mIndex.put(i + 1, (int[])subPos.clone());
        }
        return result;
    }

    @Override
    public int getTotalMediaItemCount() {
        int count = 0;
        for (MediaSet set : this.mSources) {
            count += set.getTotalMediaItemCount();
        }
        return count;
    }

    @Override
    public long reload() {
        boolean changed = false;
        int n = this.mSources.length;
        for (int i = 0; i < n; ++i) {
            if (this.mSources[i].reload() <= this.mDataVersion) continue;
            changed = true;
        }
        if (changed) {
            this.mDataVersion = LocalMergeAlbum.nextVersionNumber();
            this.updateData();
            this.invalidateCache();
        }
        return this.mDataVersion;
    }

    @Override
    public void onContentDirty() {
        this.notifyContentChanged();
    }

    @Override
    public int getSupportedOperations() {
        return this.mSupportedOperation;
    }

    @Override
    public void delete() {
        for (MediaSet set : this.mSources) {
            set.delete();
        }
    }

    @Override
    public void rotate(int degrees) {
        for (MediaSet set : this.mSources) {
            try {
                set.rotate(degrees);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isLeafAlbum() {
        return true;
    }

    private static class FetchCache {
        private MediaSet mBaseSet;
        private SoftReference<ArrayList<MediaItem>> mCacheRef;
        private int mStartPos;

        public FetchCache(MediaSet baseSet) {
            this.mBaseSet = baseSet;
        }

        public void invalidate() {
            this.mCacheRef = null;
        }

        public MediaItem getItem(int index) {
            boolean needLoading = false;
            ArrayList<MediaItem> cache = null;
            if (this.mCacheRef == null || index < this.mStartPos || index >= this.mStartPos + 64) {
                needLoading = true;
            } else {
                cache = this.mCacheRef.get();
                if (cache == null) {
                    needLoading = true;
                }
            }
            if (needLoading) {
                cache = this.mBaseSet.getMediaItem(index, 64);
                this.mCacheRef = new SoftReference<ArrayList<MediaItem>>(cache);
                this.mStartPos = index;
            }
            if (index < this.mStartPos || index >= this.mStartPos + cache.size()) {
                return null;
            }
            return cache.get(index - this.mStartPos);
        }
    }
}

