/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.content.ContentProviderClient;
import android.content.ContentUris;
import android.content.UriMatcher;
import android.net.Uri;
import android.util.Log;
import deviceinfo.mayur.medialibrary.data.DataManager;
import deviceinfo.mayur.medialibrary.data.LocalAlbum;
import deviceinfo.mayur.medialibrary.data.LocalAlbumSet;
import deviceinfo.mayur.medialibrary.data.LocalImage;
import deviceinfo.mayur.medialibrary.data.LocalMediaItem;
import deviceinfo.mayur.medialibrary.data.LocalMergeAlbum;
import deviceinfo.mayur.medialibrary.data.LocalVideo;
import deviceinfo.mayur.medialibrary.data.MediaDataContext;
import deviceinfo.mayur.medialibrary.data.MediaItem;
import deviceinfo.mayur.medialibrary.data.MediaObject;
import deviceinfo.mayur.medialibrary.data.MediaSet;
import deviceinfo.mayur.medialibrary.data.MediaSource;
import deviceinfo.mayur.medialibrary.data.Path;
import deviceinfo.mayur.medialibrary.data.PathMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

class LocalSource
extends MediaSource {
    public static final String KEY_BUCKET_ID = "bucketId";
    private MediaDataContext mApplication;
    private PathMatcher mMatcher;
    private static final int NO_MATCH = -1;
    private final UriMatcher mUriMatcher = new UriMatcher(-1);
    public static final Comparator<MediaSource.PathId> sIdComparator = new IdComparator();
    private static final int LOCAL_IMAGE_ALBUMSET = 0;
    private static final int LOCAL_VIDEO_ALBUMSET = 1;
    private static final int LOCAL_IMAGE_ALBUM = 2;
    private static final int LOCAL_VIDEO_ALBUM = 3;
    private static final int LOCAL_IMAGE_ITEM = 4;
    private static final int LOCAL_VIDEO_ITEM = 5;
    private static final int LOCAL_ALL_ALBUMSET = 6;
    private static final int LOCAL_ALL_ALBUM = 7;
    private static final String TAG = "LocalSource";
    private ContentProviderClient mClient;
    private static final int MEDIA_TYPE_ALL = 0;
    private static final int MEDIA_TYPE_IMAGE = 1;
    private static final int MEDIA_TYPE_VIDEO = 4;

    public LocalSource(MediaDataContext context) {
        super("local");
        this.mApplication = context;
        this.mMatcher = new PathMatcher();
        this.mMatcher.add("/local/image", 0);
        this.mMatcher.add("/local/video", 1);
        this.mMatcher.add("/local/all", 6);
        this.mMatcher.add("/local/image/*", 2);
        this.mMatcher.add("/local/video/*", 3);
        this.mMatcher.add("/local/all/*", 7);
        this.mMatcher.add("/local/image/item/*", 4);
        this.mMatcher.add("/local/video/item/*", 5);
        this.mUriMatcher.addURI("media", "external/images/media/#", 4);
        this.mUriMatcher.addURI("media", "external/video/media/#", 5);
        this.mUriMatcher.addURI("media", "external/images/media", 2);
        this.mUriMatcher.addURI("media", "external/video/media", 3);
        this.mUriMatcher.addURI("media", "external/file", 7);
    }

    @Override
    public MediaObject createMediaObject(Path path) {
        MediaDataContext app = this.mApplication;
        switch (this.mMatcher.match(path)) {
            case 0: 
            case 1: 
            case 6: {
                return new LocalAlbumSet(path, this.mApplication);
            }
            case 2: {
                return new LocalAlbum(path, app, this.mMatcher.getIntVar(0), true);
            }
            case 3: {
                return new LocalAlbum(path, app, this.mMatcher.getIntVar(0), false);
            }
            case 7: {
                int bucketId = this.mMatcher.getIntVar(0);
                DataManager dataManager = app.getDataManager();
                MediaSet imageSet = (MediaSet)dataManager.getMediaObject(LocalAlbumSet.PATH_IMAGE.getChild(bucketId));
                MediaSet videoSet = (MediaSet)dataManager.getMediaObject(LocalAlbumSet.PATH_VIDEO.getChild(bucketId));
                Comparator<MediaItem> comp = DataManager.sDateTakenComparator;
                return new LocalMergeAlbum(path, comp, new MediaSet[]{imageSet, videoSet}, bucketId);
            }
            case 4: {
                return new LocalImage(path, this.mApplication, this.mMatcher.getIntVar(0));
            }
            case 5: {
                return new LocalVideo(path, this.mApplication, this.mMatcher.getIntVar(0));
            }
        }
        throw new RuntimeException("bad path: " + path);
    }

    private static int getMediaType(String type, int defaultType) {
        if (type == null) {
            return defaultType;
        }
        try {
            int value = Integer.parseInt(type);
            if ((value & 5) != 0) {
                return value;
            }
        }
        catch (NumberFormatException e) {
            Log.w((String)TAG, (String)("invalid type: " + type), (Throwable)e);
        }
        return defaultType;
    }

    private Path getAlbumPath(Uri uri, int defaultType) {
        int mediaType = LocalSource.getMediaType(uri.getQueryParameter("mediaTypes"), defaultType);
        String bucketId = uri.getQueryParameter(KEY_BUCKET_ID);
        int id = 0;
        try {
            id = Integer.parseInt(bucketId);
        }
        catch (NumberFormatException e) {
            Log.w((String)TAG, (String)("invalid bucket id: " + bucketId), (Throwable)e);
            return null;
        }
        switch (mediaType) {
            case 1: {
                return Path.fromString("/local/image").getChild(id);
            }
            case 4: {
                return Path.fromString("/local/video").getChild(id);
            }
        }
        return Path.fromString("/local/all").getChild(id);
    }

    @Override
    public Path findPathByUri(Uri uri, String type) {
        try {
            switch (this.mUriMatcher.match(uri)) {
                case 4: {
                    long id = ContentUris.parseId((Uri)uri);
                    return id >= 0L ? LocalImage.ITEM_PATH.getChild(id) : null;
                }
                case 5: {
                    long id = ContentUris.parseId((Uri)uri);
                    return id >= 0L ? LocalVideo.ITEM_PATH.getChild(id) : null;
                }
                case 2: {
                    return this.getAlbumPath(uri, 1);
                }
                case 3: {
                    return this.getAlbumPath(uri, 4);
                }
                case 7: {
                    return this.getAlbumPath(uri, 0);
                }
            }
        }
        catch (NumberFormatException e) {
            Log.w((String)TAG, (String)("uri: " + uri.toString()), (Throwable)e);
        }
        return null;
    }

    @Override
    public Path getDefaultSetOf(Path item) {
        MediaObject object = this.mApplication.getDataManager().getMediaObject(item);
        if (object instanceof LocalMediaItem) {
            return Path.fromString("/local/all").getChild(String.valueOf(((LocalMediaItem)object).getBucketId()));
        }
        return null;
    }

    @Override
    public void mapMediaItems(ArrayList<MediaSource.PathId> list, MediaSet.ItemConsumer consumer) {
        ArrayList<MediaSource.PathId> imageList = new ArrayList<MediaSource.PathId>();
        ArrayList<MediaSource.PathId> videoList = new ArrayList<MediaSource.PathId>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            MediaSource.PathId pid = list.get(i);
            Path parent = pid.path.getParent();
            if (parent == LocalImage.ITEM_PATH) {
                imageList.add(pid);
                continue;
            }
            if (parent != LocalVideo.ITEM_PATH) continue;
            videoList.add(pid);
        }
        this.processMapMediaItems(imageList, consumer, true);
        this.processMapMediaItems(videoList, consumer, false);
    }

    private void processMapMediaItems(ArrayList<MediaSource.PathId> list, MediaSet.ItemConsumer consumer, boolean isImage) {
        Collections.sort(list, sIdComparator);
        int n = list.size();
        int i = 0;
        while (i < n) {
            int j;
            MediaSource.PathId pid = list.get(i);
            ArrayList<Integer> ids = new ArrayList<Integer>();
            int startId = Integer.parseInt(pid.path.getSuffix());
            ids.add(startId);
            for (j = i + 1; j < n; ++j) {
                MediaSource.PathId pid2 = list.get(j);
                int curId = Integer.parseInt(pid2.path.getSuffix());
                if (curId - startId >= 500) break;
                ids.add(curId);
            }
            MediaItem[] items = LocalAlbum.getMediaItemById(this.mApplication, isImage, ids);
            for (int k = i; k < j; ++k) {
                MediaSource.PathId pid2 = list.get(k);
                consumer.consume(pid2.id, items[k - i]);
            }
            i = j;
        }
    }

    @Override
    public void resume() {
        this.mClient = this.mApplication.getContentResolver().acquireContentProviderClient("media");
    }

    @Override
    public void pause() {
        this.mClient.release();
        this.mClient = null;
    }

    private static class IdComparator
    implements Comparator<MediaSource.PathId> {
        private IdComparator() {
        }

        @Override
        public int compare(MediaSource.PathId p1, MediaSource.PathId p2) {
            int len2;
            String s1 = p1.path.getSuffix();
            String s2 = p2.path.getSuffix();
            int len1 = s1.length();
            if (len1 < (len2 = s2.length())) {
                return -1;
            }
            if (len1 > len2) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    }
}

