/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.content.ContentResolver;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapRegionDecoder;
import android.net.Uri;
import android.provider.MediaStore;
import android.util.Log;
import deviceinfo.mayur.medialibrary.data.ImageCacheRequest;
import deviceinfo.mayur.medialibrary.data.LocalAlbum;
import deviceinfo.mayur.medialibrary.data.LocalImage;
import deviceinfo.mayur.medialibrary.data.LocalMediaItem;
import deviceinfo.mayur.medialibrary.data.MediaDataContext;
import deviceinfo.mayur.medialibrary.data.MediaDetails;
import deviceinfo.mayur.medialibrary.data.Path;
import deviceinfo.mayur.medialibrary.util.BitmapUtils;
import deviceinfo.mayur.medialibrary.util.GalleryUtils;
import deviceinfo.mayur.medialibrary.util.ThreadPool;
import deviceinfo.mayur.medialibrary.util.UpdateHelper;

public class LocalVideo
extends LocalMediaItem {
    private static final String TAG = "LocalVideo";
    static final Path ITEM_PATH = Path.fromString("/local/video/item");
    private static final int INDEX_ID = 0;
    private static final int INDEX_CAPTION = 1;
    private static final int INDEX_MIME_TYPE = 2;
    private static final int INDEX_LATITUDE = 3;
    private static final int INDEX_LONGITUDE = 4;
    private static final int INDEX_DATE_TAKEN = 5;
    private static final int INDEX_DATE_ADDED = 6;
    private static final int INDEX_DATE_MODIFIED = 7;
    private static final int INDEX_DATA = 8;
    private static final int INDEX_DURATION = 9;
    private static final int INDEX_BUCKET_ID = 10;
    private static final int INDEX_SIZE = 11;
    private static final int INDEX_RESOLUTION = 12;
    static final String[] PROJECTION = new String[]{"_id", "title", "mime_type", "latitude", "longitude", "datetaken", "date_added", "date_modified", "_data", "duration", "bucket_id", "_size", "resolution"};
    private final MediaDataContext mApplication;
    public int durationInSec;

    public LocalVideo(Path path, MediaDataContext application, Cursor cursor) {
        super(path, LocalVideo.nextVersionNumber());
        this.mApplication = application;
        this.loadFromCursor(cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalVideo(Path path, MediaDataContext context, int id) {
        block5: {
            super(path, LocalVideo.nextVersionNumber());
            this.mApplication = context;
            ContentResolver resolver = this.mApplication.getContentResolver();
            Uri uri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
            Cursor cursor = LocalAlbum.getItemCursor(resolver, uri, PROJECTION, id);
            if (cursor == null) {
                throw new RuntimeException("cannot get cursor for: " + path);
            }
            try {
                if (cursor.moveToNext()) {
                    this.loadFromCursor(cursor);
                    break block5;
                }
                throw new RuntimeException("cannot find data for: " + path);
            }
            finally {
                cursor.close();
            }
        }
    }

    private void loadFromCursor(Cursor cursor) {
        this.id = cursor.getInt(0);
        this.caption = cursor.getString(1);
        this.mimeType = cursor.getString(2);
        this.latitude = cursor.getDouble(3);
        this.longitude = cursor.getDouble(4);
        this.dateTakenInMs = cursor.getLong(5);
        this.dateAddedInSec = cursor.getLong(6);
        this.dateModifiedInSec = cursor.getLong(7);
        this.filePath = cursor.getString(8);
        this.durationInSec = cursor.getInt(9) / 1000;
        this.bucketId = cursor.getInt(10);
        this.fileSize = cursor.getLong(11);
        this.parseResolution(cursor.getString(12));
    }

    private void parseResolution(String resolution) {
        if (resolution == null) {
            return;
        }
        int m = resolution.indexOf(120);
        if (m == -1) {
            return;
        }
        try {
            int w = Integer.parseInt(resolution.substring(0, m));
            int h = Integer.parseInt(resolution.substring(m + 1));
            this.width = w;
            this.height = h;
        }
        catch (Throwable t) {
            Log.w((String)TAG, (Throwable)t);
        }
    }

    @Override
    protected boolean updateFromCursor(Cursor cursor) {
        UpdateHelper uh = new UpdateHelper();
        this.id = uh.update(this.id, cursor.getInt(0));
        this.caption = uh.update(this.caption, cursor.getString(1));
        this.mimeType = uh.update(this.mimeType, cursor.getString(2));
        this.latitude = uh.update(this.latitude, cursor.getDouble(3));
        this.longitude = uh.update(this.longitude, cursor.getDouble(4));
        this.dateTakenInMs = uh.update(this.dateTakenInMs, cursor.getLong(5));
        this.dateAddedInSec = uh.update(this.dateAddedInSec, cursor.getLong(6));
        this.dateModifiedInSec = uh.update(this.dateModifiedInSec, cursor.getLong(7));
        this.filePath = uh.update(this.filePath, cursor.getString(8));
        this.durationInSec = uh.update(this.durationInSec, cursor.getInt(9) / 1000);
        this.bucketId = uh.update(this.bucketId, cursor.getInt(10));
        this.fileSize = uh.update(this.fileSize, cursor.getLong(11));
        return uh.isUpdated();
    }

    @Override
    public ThreadPool.Job<Bitmap> requestImage(int type) {
        return new LocalVideoRequest(this.mApplication, this.getPath(), this.dateModifiedInSec, type, this.filePath);
    }

    @Override
    public ThreadPool.Job<BitmapRegionDecoder> requestLargeImage() {
        throw new UnsupportedOperationException("Cannot regquest a large image to a local video!");
    }

    @Override
    public int getSupportedOperations() {
        return 1157;
    }

    @Override
    public void delete() {
        GalleryUtils.assertNotInRenderThread();
        Uri baseUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
        this.mApplication.getContentResolver().delete(baseUri, "_id=?", new String[]{String.valueOf(this.id)});
    }

    @Override
    public void rotate(int degrees) {
    }

    @Override
    public Uri getContentUri() {
        Uri baseUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
        return baseUri.buildUpon().appendPath(String.valueOf(this.id)).build();
    }

    @Override
    public Uri getPlayUri() {
        return this.getContentUri();
    }

    @Override
    public int getMediaType() {
        return 4;
    }

    @Override
    public MediaDetails getDetails() {
        MediaDetails details = super.getDetails();
        int s = this.durationInSec;
        if (s > 0) {
            details.addDetail(8, GalleryUtils.formatDuration(this.mApplication.getContext(), this.durationInSec));
        }
        return details;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public static class LocalVideoRequest
    extends ImageCacheRequest {
        private String mLocalFilePath;

        LocalVideoRequest(MediaDataContext application, Path path, long date, int type, String localFilePath) {
            super(application, path, date, type, LocalImage.getTargetSize(type));
            this.mLocalFilePath = localFilePath;
        }

        @Override
        public Bitmap onDecodeOriginal(ThreadPool.JobContext jc, int type) {
            Bitmap bitmap = BitmapUtils.createVideoThumbnail(this.mLocalFilePath);
            if (bitmap == null || jc.isCancelled()) {
                return null;
            }
            return bitmap;
        }

        @Override
        public Bitmap beforeReturningBitmap(Bitmap bitmap) {
            return bitmap;
        }
    }
}

