/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.widget.Toast;
import deviceinfo.mayur.medialibrary.R;
import deviceinfo.mayur.medialibrary.data.Clustering;
import deviceinfo.mayur.medialibrary.data.MediaItem;
import deviceinfo.mayur.medialibrary.data.MediaSet;
import deviceinfo.mayur.medialibrary.data.Path;
import deviceinfo.mayur.medialibrary.util.GalleryUtils;
import deviceinfo.mayur.medialibrary.util.ReverseGeocoder;
import java.util.ArrayList;

class LocationClustering
extends Clustering {
    private static final String TAG = "LocationClustering";
    private static final int MIN_GROUPS = 1;
    private static final int MAX_GROUPS = 20;
    private static final int MAX_ITERATIONS = 30;
    private static final float STOP_CHANGE_RATIO = 0.01f;
    private Context mContext;
    private ArrayList<ArrayList<SmallItem>> mClusters;
    private ArrayList<String> mNames;
    private String mNoLocationString;
    private Handler mHandler;

    public LocationClustering(Context context) {
        this.mContext = context;
        this.mNoLocationString = this.mContext.getResources().getString(R.string.no_location);
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run(MediaSet baseSet) {
        final int total = baseSet.getTotalMediaItemCount();
        final SmallItem[] buf = new SmallItem[total];
        final double[] latLong = new double[2];
        baseSet.enumerateTotalMediaItems(new MediaSet.ItemConsumer(){

            @Override
            public void consume(int index, MediaItem item) {
                if (index < 0 || index >= total) {
                    return;
                }
                SmallItem s = new SmallItem();
                s.path = item.getPath();
                item.getLatLong(latLong);
                s.lat = latLong[0];
                s.lng = latLong[1];
                buf[index] = s;
            }
        });
        ArrayList<SmallItem> withLatLong = new ArrayList<SmallItem>();
        ArrayList<SmallItem> withoutLatLong = new ArrayList<SmallItem>();
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < total; ++i) {
            SmallItem s = buf[i];
            if (s == null) continue;
            if (GalleryUtils.isValidLocation(s.lat, s.lng)) {
                withLatLong.add(s);
                points.add(new Point(s.lat, s.lng));
                continue;
            }
            withoutLatLong.add(s);
        }
        ArrayList clusters = new ArrayList();
        int m = withLatLong.size();
        if (m > 0) {
            void var13_19;
            void var13_17;
            Point[] pointsArray = new Point[m];
            pointsArray = points.toArray(pointsArray);
            int[] bestK = new int[1];
            int[] index = LocationClustering.kMeans(pointsArray, bestK);
            boolean bl = false;
            while (var13_17 < bestK[0]) {
                clusters.add(new ArrayList());
                ++var13_17;
            }
            boolean bl2 = false;
            while (var13_19 < m) {
                ((ArrayList)clusters.get(index[var13_19])).add(withLatLong.get((int)var13_19));
                ++var13_19;
            }
        }
        ReverseGeocoder geocoder = new ReverseGeocoder(this.mContext);
        this.mNames = new ArrayList();
        boolean hasUnresolvedAddress = false;
        this.mClusters = new ArrayList();
        for (ArrayList arrayList : clusters) {
            String name = LocationClustering.generateName(arrayList, geocoder);
            if (name != null) {
                this.mNames.add(name);
                this.mClusters.add(arrayList);
                continue;
            }
            withoutLatLong.addAll(arrayList);
            hasUnresolvedAddress = true;
        }
        if (withoutLatLong.size() > 0) {
            this.mNames.add(this.mNoLocationString);
            this.mClusters.add(withoutLatLong);
        }
        if (hasUnresolvedAddress) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Toast.makeText((Context)LocationClustering.this.mContext, (int)R.string.no_connectivity, (int)1).show();
                }
            });
        }
    }

    private static String generateName(ArrayList<SmallItem> items, ReverseGeocoder geocoder) {
        ReverseGeocoder.SetLatLong set = new ReverseGeocoder.SetLatLong();
        int n = items.size();
        for (int i = 0; i < n; ++i) {
            SmallItem item = items.get(i);
            double itemLatitude = item.lat;
            double itemLongitude = item.lng;
            if (set.mMinLatLatitude > itemLatitude) {
                set.mMinLatLatitude = itemLatitude;
                set.mMinLatLongitude = itemLongitude;
            }
            if (set.mMaxLatLatitude < itemLatitude) {
                set.mMaxLatLatitude = itemLatitude;
                set.mMaxLatLongitude = itemLongitude;
            }
            if (set.mMinLonLongitude > itemLongitude) {
                set.mMinLonLatitude = itemLatitude;
                set.mMinLonLongitude = itemLongitude;
            }
            if (!(set.mMaxLonLongitude < itemLongitude)) continue;
            set.mMaxLonLatitude = itemLatitude;
            set.mMaxLonLongitude = itemLongitude;
        }
        return geocoder.computeAddress(set);
    }

    @Override
    public int getNumberOfClusters() {
        return this.mClusters.size();
    }

    @Override
    public ArrayList<Path> getCluster(int index) {
        ArrayList<SmallItem> items = this.mClusters.get(index);
        ArrayList<Path> result = new ArrayList<Path>(items.size());
        int n = items.size();
        for (int i = 0; i < n; ++i) {
            result.add(items.get((int)i).path);
        }
        return result;
    }

    @Override
    public String getClusterName(int index) {
        return this.mNames.get(index);
    }

    private static int[] kMeans(Point[] points, int[] bestK) {
        int n = points.length;
        int minK = Math.min(n, 1);
        int maxK = Math.min(n, 20);
        Point[] center = new Point[maxK];
        Point[] groupSum = new Point[maxK];
        int[] groupCount = new int[maxK];
        int[] grouping = new int[n];
        for (int i = 0; i < maxK; ++i) {
            center[i] = new Point();
            groupSum[i] = new Point();
        }
        float bestScore = Float.MAX_VALUE;
        int[] bestGrouping = new int[n];
        bestK[0] = 1;
        float lastDistance = 0.0f;
        float totalDistance = 0.0f;
        for (int k = minK; k <= maxK; ++k) {
            int delta = n / k;
            for (int i = 0; i < k; ++i) {
                Point p = points[i * delta];
                center[i].latRad = p.latRad;
                center[i].lngRad = p.lngRad;
            }
            for (int iter = 0; iter < 30; ++iter) {
                int i;
                for (i = 0; i < k; ++i) {
                    groupSum[i].latRad = 0.0;
                    groupSum[i].lngRad = 0.0;
                    groupCount[i] = 0;
                }
                totalDistance = 0.0f;
                for (i = 0; i < n; ++i) {
                    Point p = points[i];
                    float bestDistance = Float.MAX_VALUE;
                    int bestIndex = 0;
                    for (int j = 0; j < k; ++j) {
                        float distance = (float)GalleryUtils.fastDistanceMeters(p.latRad, p.lngRad, center[j].latRad, center[j].lngRad);
                        if (distance < 1.0f) {
                            distance = 0.0f;
                        }
                        if (!(distance < bestDistance)) continue;
                        bestDistance = distance;
                        bestIndex = j;
                    }
                    grouping[i] = bestIndex;
                    int n2 = bestIndex;
                    groupCount[n2] = groupCount[n2] + 1;
                    groupSum[bestIndex].latRad += p.latRad;
                    groupSum[bestIndex].lngRad += p.lngRad;
                    totalDistance += bestDistance;
                }
                for (i = 0; i < k; ++i) {
                    if (groupCount[i] <= 0) continue;
                    center[i].latRad = groupSum[i].latRad / (double)groupCount[i];
                    center[i].lngRad = groupSum[i].lngRad / (double)groupCount[i];
                }
                if (totalDistance == 0.0f || Math.abs(lastDistance - totalDistance) / totalDistance < 0.01f) break;
                lastDistance = totalDistance;
            }
            int[] reassign = new int[k];
            int realK = 0;
            for (int i = 0; i < k; ++i) {
                if (groupCount[i] <= 0) continue;
                reassign[i] = realK++;
            }
            float score = totalDistance * (float)Math.sqrt(realK);
            if (!(score < bestScore)) continue;
            bestScore = score;
            bestK[0] = realK;
            for (int i = 0; i < n; ++i) {
                bestGrouping[i] = reassign[grouping[i]];
            }
            if (score == 0.0f) break;
        }
        return bestGrouping;
    }

    private static class SmallItem {
        Path path;
        double lat;
        double lng;

        private SmallItem() {
        }
    }

    private static class Point {
        public double latRad;
        public double lngRad;

        public Point(double lat, double lng) {
            this.latRad = Math.toRadians(lat);
            this.lngRad = Math.toRadians(lng);
        }

        public Point() {
        }
    }
}

