/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.media.ExifInterface;
import android.util.Log;
import deviceinfo.mayur.medialibrary.R;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class MediaDetails
implements Iterable<Map.Entry<Integer, Object>> {
    private static final String TAG = "MediaDetails";
    private TreeMap<Integer, Object> mDetails = new TreeMap();
    private HashMap<Integer, Integer> mUnits = new HashMap();
    public static final int INDEX_TITLE = 1;
    public static final int INDEX_DESCRIPTION = 2;
    public static final int INDEX_DATETIME = 3;
    public static final int INDEX_LOCATION = 4;
    public static final int INDEX_WIDTH = 5;
    public static final int INDEX_HEIGHT = 6;
    public static final int INDEX_ORIENTATION = 7;
    public static final int INDEX_DURATION = 8;
    public static final int INDEX_MIMETYPE = 9;
    public static final int INDEX_SIZE = 10;
    public static final int INDEX_MAKE = 100;
    public static final int INDEX_MODEL = 101;
    public static final int INDEX_FLASH = 102;
    public static final int INDEX_FOCAL_LENGTH = 103;
    public static final int INDEX_WHITE_BALANCE = 104;
    public static final int INDEX_APERTURE = 105;
    public static final int INDEX_SHUTTER_SPEED = 106;
    public static final int INDEX_EXPOSURE_TIME = 107;
    public static final int INDEX_ISO = 108;
    public static final int INDEX_PATH = 200;

    public void addDetail(int index, Object value) {
        this.mDetails.put(index, value);
    }

    public Object getDetail(int index) {
        return this.mDetails.get(index);
    }

    public int size() {
        return this.mDetails.size();
    }

    @Override
    public Iterator<Map.Entry<Integer, Object>> iterator() {
        return this.mDetails.entrySet().iterator();
    }

    public void setUnit(int index, int unit) {
        this.mUnits.put(index, unit);
    }

    public boolean hasUnit(int index) {
        return this.mUnits.containsKey(index);
    }

    public int getUnit(int index) {
        return this.mUnits.get(index);
    }

    private static void setExifData(MediaDetails details, ExifInterface exif, String tag, int key) {
        String value = exif.getAttribute(tag);
        if (value != null) {
            if (key == 102) {
                FlashState state = new FlashState(Integer.valueOf(value.toString()));
                details.addDetail(key, state);
            } else {
                details.addDetail(key, value);
            }
        }
    }

    public static void extractExifInfo(MediaDetails details, String filePath) {
        try {
            ExifInterface exif = new ExifInterface(filePath);
            MediaDetails.setExifData(details, exif, "Flash", 102);
            MediaDetails.setExifData(details, exif, "ImageWidth", 5);
            MediaDetails.setExifData(details, exif, "ImageLength", 6);
            MediaDetails.setExifData(details, exif, "Make", 100);
            MediaDetails.setExifData(details, exif, "Model", 101);
            MediaDetails.setExifData(details, exif, "FNumber", 105);
            MediaDetails.setExifData(details, exif, "ISOSpeedRatings", 108);
            MediaDetails.setExifData(details, exif, "WhiteBalance", 104);
            MediaDetails.setExifData(details, exif, "ExposureTime", 107);
            double data = exif.getAttributeDouble("FocalLength", 0.0);
            if (data != 0.0) {
                details.addDetail(103, data);
                details.setUnit(103, R.string.unit_mm);
            }
        }
        catch (IOException ex) {
            Log.w((String)TAG, (String)"", (Throwable)ex);
        }
    }

    public static class FlashState {
        private static int FLASH_FIRED_MASK = 1;
        private static int FLASH_RETURN_MASK = 6;
        private static int FLASH_MODE_MASK = 24;
        private static int FLASH_FUNCTION_MASK = 32;
        private static int FLASH_RED_EYE_MASK = 64;
        private int mState;

        public FlashState(int state) {
            this.mState = state;
        }

        public boolean isFlashFired() {
            return (this.mState & FLASH_FIRED_MASK) != 0;
        }
    }
}

