/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.graphics.Bitmap;
import android.graphics.BitmapRegionDecoder;
import deviceinfo.mayur.medialibrary.data.BytesBufferPool;
import deviceinfo.mayur.medialibrary.data.Face;
import deviceinfo.mayur.medialibrary.data.MediaObject;
import deviceinfo.mayur.medialibrary.data.Path;
import deviceinfo.mayur.medialibrary.util.ThreadPool;

public abstract class MediaItem
extends MediaObject {
    public static final int TYPE_THUMBNAIL = 1;
    public static final int TYPE_MICROTHUMBNAIL = 2;
    public static final int CACHED_IMAGE_QUALITY = 95;
    public static final int IMAGE_READY = 0;
    public static final int IMAGE_WAIT = 1;
    public static final int IMAGE_ERROR = -1;
    public static final String MIME_TYPE_JPEG = "image/jpeg";
    private static final int BYTESBUFFE_POOL_SIZE = 4;
    private static final int BYTESBUFFER_SIZE = 204800;
    private static int sMicrothumbnailTargetSize = 200;
    private static final BytesBufferPool sMicroThumbBufferPool = new BytesBufferPool(4, 204800);
    private static int sThumbnailTargetSize = 640;
    public static final double INVALID_LATLNG = 0.0;

    public abstract ThreadPool.Job<Bitmap> requestImage(int var1);

    public abstract ThreadPool.Job<BitmapRegionDecoder> requestLargeImage();

    public MediaItem(Path path, long version) {
        super(path, version);
    }

    public long getDateInMs() {
        return 0L;
    }

    public String getName() {
        return null;
    }

    public void getLatLong(double[] latLong) {
        latLong[0] = 0.0;
        latLong[1] = 0.0;
    }

    public String[] getTags() {
        return null;
    }

    public Face[] getFaces() {
        return null;
    }

    public int getFullImageRotation() {
        return this.getRotation();
    }

    public int getRotation() {
        return 0;
    }

    public long getSize() {
        return 0L;
    }

    public abstract String getMimeType();

    public String getFilePath() {
        return "";
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public static int getTargetSize(int type) {
        switch (type) {
            case 1: {
                return sThumbnailTargetSize;
            }
            case 2: {
                return sMicrothumbnailTargetSize;
            }
        }
        throw new RuntimeException("should only request thumb/microthumb from cache");
    }

    public static BytesBufferPool getBytesBufferPool() {
        return sMicroThumbBufferPool;
    }

    public static void setThumbnailSizes(int size, int microSize) {
        sThumbnailTargetSize = size;
        if (sMicrothumbnailTargetSize != microSize) {
            sMicrothumbnailTargetSize = microSize;
        }
    }
}

