/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.net.Uri;
import deviceinfo.mayur.medialibrary.data.MediaDetails;
import deviceinfo.mayur.medialibrary.data.Path;

public abstract class MediaObject {
    private static final String TAG = "MediaObject";
    public static final long INVALID_DATA_VERSION = -1L;
    public static final int SUPPORT_DELETE = 1;
    public static final int SUPPORT_ROTATE = 2;
    public static final int SUPPORT_SHARE = 4;
    public static final int SUPPORT_CROP = 8;
    public static final int SUPPORT_SHOW_ON_MAP = 16;
    public static final int SUPPORT_SETAS = 32;
    public static final int SUPPORT_FULL_IMAGE = 64;
    public static final int SUPPORT_PLAY = 128;
    public static final int SUPPORT_CACHE = 256;
    public static final int SUPPORT_EDIT = 512;
    public static final int SUPPORT_INFO = 1024;
    public static final int SUPPORT_IMPORT = 2048;
    public static final int SUPPORT_ALL = -1;
    public static final int MEDIA_TYPE_UNKNOWN = 1;
    public static final int MEDIA_TYPE_IMAGE = 2;
    public static final int MEDIA_TYPE_VIDEO = 4;
    public static final int MEDIA_TYPE_ALL = 6;
    public static final String MEDIA_TYPE_IMAGE_STRING = "image";
    public static final String MEDIA_TYPE_VIDEO_STRING = "video";
    public static final String MEDIA_TYPE_ALL_STRING = "all";
    public static final int CACHE_FLAG_NO = 0;
    public static final int CACHE_FLAG_SCREENNAIL = 1;
    public static final int CACHE_FLAG_FULL = 2;
    public static final int CACHE_STATUS_NOT_CACHED = 0;
    public static final int CACHE_STATUS_CACHING = 1;
    public static final int CACHE_STATUS_CACHED_SCREENNAIL = 2;
    public static final int CACHE_STATUS_CACHED_FULL = 3;
    private static long sVersionSerial = 0L;
    protected long mDataVersion;
    protected final Path mPath;

    public MediaObject(Path path, long version) {
        path.setObject(this);
        this.mPath = path;
        this.mDataVersion = version;
    }

    public Path getPath() {
        return this.mPath;
    }

    public int getSupportedOperations() {
        return 0;
    }

    public void delete() {
        throw new UnsupportedOperationException();
    }

    public void rotate(int degrees) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Uri getContentUri() {
        throw new UnsupportedOperationException();
    }

    public Uri getPlayUri() {
        throw new UnsupportedOperationException();
    }

    public int getMediaType() {
        return 1;
    }

    public boolean Import() {
        throw new UnsupportedOperationException();
    }

    public MediaDetails getDetails() {
        MediaDetails details = new MediaDetails();
        return details;
    }

    public long getDataVersion() {
        return this.mDataVersion;
    }

    public int getCacheFlag() {
        return 0;
    }

    public int getCacheStatus() {
        throw new UnsupportedOperationException();
    }

    public long getCacheSize() {
        throw new UnsupportedOperationException();
    }

    public void cache(int flag) {
        throw new UnsupportedOperationException();
    }

    public static synchronized long nextVersionNumber() {
        return ++sVersionSerial;
    }

    public static int getTypeFromString(String s) {
        if (MEDIA_TYPE_ALL_STRING.equals(s)) {
            return 6;
        }
        if (MEDIA_TYPE_IMAGE_STRING.equals(s)) {
            return 2;
        }
        if (MEDIA_TYPE_VIDEO_STRING.equals(s)) {
            return 4;
        }
        throw new IllegalArgumentException(s);
    }

    public static String getTypeString(int type) {
        switch (type) {
            case 2: {
                return MEDIA_TYPE_IMAGE_STRING;
            }
            case 4: {
                return MEDIA_TYPE_VIDEO_STRING;
            }
            case 6: {
                return MEDIA_TYPE_ALL_STRING;
            }
        }
        throw new IllegalArgumentException();
    }
}

