/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.util.Log;
import deviceinfo.mayur.medialibrary.data.ContentListener;
import deviceinfo.mayur.medialibrary.data.MediaDetails;
import deviceinfo.mayur.medialibrary.data.MediaItem;
import deviceinfo.mayur.medialibrary.data.MediaObject;
import deviceinfo.mayur.medialibrary.data.Path;
import deviceinfo.mayur.medialibrary.util.Future;
import deviceinfo.mayur.medialibrary.util.Utils;
import java.util.ArrayList;
import java.util.WeakHashMap;

public abstract class MediaSet
extends MediaObject {
    private static final String TAG = "MediaSet";
    public static final int MEDIAITEM_BATCH_FETCH_COUNT = 500;
    public static final int INDEX_NOT_FOUND = -1;
    public static final int SYNC_RESULT_SUCCESS = 0;
    public static final int SYNC_RESULT_CANCELLED = 1;
    public static final int SYNC_RESULT_ERROR = 2;
    private WeakHashMap<ContentListener, Object> mListeners = new WeakHashMap();
    private static final Future<Integer> FUTURE_STUB = new Future<Integer>(){

        @Override
        public void cancel() {
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public Integer get() {
            return 0;
        }

        @Override
        public void waitDone() {
        }
    };

    public MediaSet(Path path, long version) {
        super(path, version);
    }

    public int getMediaItemCount() {
        return 0;
    }

    public ArrayList<MediaItem> getMediaItem(int start, int count) {
        return new ArrayList<MediaItem>();
    }

    public MediaItem getCoverMediaItem() {
        ArrayList<MediaItem> items = this.getMediaItem(0, 1);
        if (items.size() > 0) {
            return items.get(0);
        }
        int n = this.getSubMediaSetCount();
        for (int i = 0; i < n; ++i) {
            MediaItem cover = this.getSubMediaSet(i).getCoverMediaItem();
            if (cover == null) continue;
            return cover;
        }
        return null;
    }

    public int getSubMediaSetCount() {
        return 0;
    }

    public MediaSet getSubMediaSet(int index) {
        throw new IndexOutOfBoundsException();
    }

    public boolean isLeafAlbum() {
        return false;
    }

    public boolean isCameraRoll() {
        return false;
    }

    public boolean isLoading() {
        return false;
    }

    public int getTotalMediaItemCount() {
        int total = this.getMediaItemCount();
        int n = this.getSubMediaSetCount();
        for (int i = 0; i < n; ++i) {
            total += this.getSubMediaSet(i).getTotalMediaItemCount();
        }
        return total;
    }

    public int getIndexOfItem(Path path, int hint) {
        int start = Math.max(0, hint - 250);
        ArrayList<MediaItem> list = this.getMediaItem(start, 500);
        int index = this.getIndexOf(path, list);
        if (index != -1) {
            return start + index;
        }
        start = start == 0 ? 500 : 0;
        list = this.getMediaItem(start, 500);
        while ((index = this.getIndexOf(path, list)) == -1) {
            if (list.size() < 500) {
                return -1;
            }
            list = this.getMediaItem(start += 500, 500);
        }
        return start + index;
    }

    protected int getIndexOf(Path path, ArrayList<MediaItem> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            MediaObject item = list.get(i);
            if (item == null || item.mPath != path) continue;
            return i;
        }
        return -1;
    }

    public abstract String getName();

    public void addContentListener(ContentListener listener) {
        this.mListeners.put(listener, null);
    }

    public void removeContentListener(ContentListener listener) {
        this.mListeners.remove(listener);
    }

    public void notifyContentChanged() {
        for (ContentListener listener : this.mListeners.keySet()) {
            listener.onContentDirty();
        }
    }

    public abstract long reload();

    @Override
    public MediaDetails getDetails() {
        MediaDetails details = super.getDetails();
        details.addDetail(1, this.getName());
        return details;
    }

    public void enumerateMediaItems(ItemConsumer consumer) {
        this.enumerateMediaItems(consumer, 0);
    }

    public void enumerateTotalMediaItems(ItemConsumer consumer) {
        this.enumerateTotalMediaItems(consumer, 0);
    }

    protected int enumerateMediaItems(ItemConsumer consumer, int startIndex) {
        int count;
        int total = this.getMediaItemCount();
        for (int start = 0; start < total; start += count) {
            count = Math.min(500, total - start);
            ArrayList<MediaItem> items = this.getMediaItem(start, count);
            int n = items.size();
            for (int i = 0; i < n; ++i) {
                MediaItem item = items.get(i);
                consumer.consume(startIndex + start + i, item);
            }
        }
        return total;
    }

    protected int enumerateTotalMediaItems(ItemConsumer consumer, int startIndex) {
        int start = 0;
        start += this.enumerateMediaItems(consumer, startIndex);
        int m = this.getSubMediaSetCount();
        for (int i = 0; i < m; ++i) {
            start += this.getSubMediaSet(i).enumerateTotalMediaItems(consumer, startIndex + start);
        }
        return start;
    }

    public Future<Integer> requestSync(SyncListener listener) {
        listener.onSyncDone(this, 0);
        return FUTURE_STUB;
    }

    protected Future<Integer> requestSyncOnMultipleSets(MediaSet[] sets, SyncListener listener) {
        return new MultiSetSyncFuture(sets, listener);
    }

    private class MultiSetSyncFuture
    implements Future<Integer>,
    SyncListener {
        private static final String TAG = "Gallery.MultiSetSync";
        private final SyncListener mListener;
        private final Future<Integer>[] mFutures;
        private boolean mIsCancelled = false;
        private int mResult = -1;
        private int mPendingCount;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MultiSetSyncFuture(MediaSet[] sets, SyncListener listener) {
            this.mListener = listener;
            this.mPendingCount = sets.length;
            this.mFutures = new Future[sets.length];
            MultiSetSyncFuture multiSetSyncFuture = this;
            synchronized (multiSetSyncFuture) {
                int n = sets.length;
                for (int i = 0; i < n; ++i) {
                    this.mFutures[i] = sets[i].requestSync(this);
                    Log.d((String)TAG, (String)("  request sync: " + Utils.maskDebugInfo(sets[i].getName())));
                }
            }
        }

        @Override
        public synchronized void cancel() {
            if (this.mIsCancelled) {
                return;
            }
            this.mIsCancelled = true;
            for (Future<Integer> future : this.mFutures) {
                future.cancel();
            }
            if (this.mResult < 0) {
                this.mResult = 1;
            }
        }

        @Override
        public synchronized boolean isCancelled() {
            return this.mIsCancelled;
        }

        @Override
        public synchronized boolean isDone() {
            return this.mPendingCount == 0;
        }

        @Override
        public synchronized Integer get() {
            this.waitDone();
            return this.mResult;
        }

        @Override
        public synchronized void waitDone() {
            try {
                while (!this.isDone()) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                Log.d((String)TAG, (String)"waitDone() interrupted");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSyncDone(MediaSet mediaSet, int resultCode) {
            SyncListener listener = null;
            MultiSetSyncFuture multiSetSyncFuture = this;
            synchronized (multiSetSyncFuture) {
                if (resultCode == 2) {
                    this.mResult = 2;
                }
                --this.mPendingCount;
                if (this.mPendingCount == 0) {
                    listener = this.mListener;
                    this.notifyAll();
                }
                Log.d((String)TAG, (String)("onSyncDone: " + Utils.maskDebugInfo(mediaSet.getName()) + " #pending=" + this.mPendingCount));
            }
            if (listener != null) {
                listener.onSyncDone(MediaSet.this, this.mResult);
            }
        }
    }

    public static interface ItemConsumer {
        public void consume(int var1, MediaItem var2);
    }

    public static interface SyncListener {
        public void onSyncDone(MediaSet var1, int var2);
    }
}

