/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.net.Uri;
import android.util.Log;
import deviceinfo.mayur.medialibrary.data.DataManager;
import deviceinfo.mayur.medialibrary.data.MediaItem;
import deviceinfo.mayur.medialibrary.data.MediaObject;
import deviceinfo.mayur.medialibrary.data.MediaSet;
import deviceinfo.mayur.medialibrary.data.Path;
import java.util.ArrayList;

public abstract class MediaSource {
    private static final String TAG = "MediaSource";
    private String mPrefix;

    protected MediaSource(String prefix) {
        this.mPrefix = prefix;
    }

    public String getPrefix() {
        return this.mPrefix;
    }

    public Path findPathByUri(Uri uri, String type) {
        return null;
    }

    public abstract MediaObject createMediaObject(Path var1);

    public void pause() {
    }

    public void resume() {
    }

    public Path getDefaultSetOf(Path item) {
        return null;
    }

    public long getTotalUsedCacheSize() {
        return 0L;
    }

    public long getTotalTargetCacheSize() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapMediaItems(ArrayList<PathId> list, MediaSet.ItemConsumer consumer) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            MediaObject obj;
            PathId pid = list.get(i);
            Object object = DataManager.LOCK;
            synchronized (object) {
                obj = pid.path.getObject();
                if (obj == null) {
                    try {
                        obj = this.createMediaObject(pid.path);
                    }
                    catch (Throwable th) {
                        Log.w((String)TAG, (String)("cannot create media object: " + pid.path), (Throwable)th);
                    }
                }
            }
            if (obj == null) continue;
            consumer.consume(pid.id, (MediaItem)obj);
        }
    }

    public static class PathId {
        public Path path;
        public int id;

        public PathId(Path path, int id) {
            this.path = path;
            this.id = id;
        }
    }
}

