/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.util.Log;
import deviceinfo.mayur.medialibrary.data.MediaObject;
import deviceinfo.mayur.medialibrary.util.IdentityCache;
import deviceinfo.mayur.medialibrary.util.Utils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class Path {
    private static final String TAG = "Path";
    private static Path sRoot = new Path(null, "ROOT");
    private final Path mParent;
    private final String mSegment;
    private WeakReference<MediaObject> mObject;
    private IdentityCache<String, Path> mChildren;

    private Path(Path parent, String segment) {
        this.mParent = parent;
        this.mSegment = segment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getChild(String segment) {
        Class<Path> clazz = Path.class;
        synchronized (Path.class) {
            Path p;
            if (this.mChildren == null) {
                this.mChildren = new IdentityCache();
            } else {
                p = this.mChildren.get(segment);
                if (p != null) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return p;
                }
            }
            p = new Path(this, segment);
            this.mChildren.put(segment, p);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return p;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getParent() {
        Class<Path> clazz = Path.class;
        synchronized (Path.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mParent;
        }
    }

    public Path getChild(int segment) {
        return this.getChild(String.valueOf(segment));
    }

    public Path getChild(long segment) {
        return this.getChild(String.valueOf(segment));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(MediaObject object) {
        Class<Path> clazz = Path.class;
        synchronized (Path.class) {
            Utils.assertTrue(this.mObject == null || this.mObject.get() == null);
            this.mObject = new WeakReference<MediaObject>(object);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaObject getObject() {
        Class<Path> clazz = Path.class;
        synchronized (Path.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mObject == null ? null : (MediaObject)this.mObject.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Class<Path> clazz = Path.class;
        synchronized (Path.class) {
            StringBuilder sb = new StringBuilder();
            String[] segments = this.split();
            for (int i = 0; i < segments.length; ++i) {
                sb.append("/");
                sb.append(segments[i]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path fromString(String s) {
        Class<Path> clazz = Path.class;
        synchronized (Path.class) {
            String[] segments = Path.split(s);
            Path current = sRoot;
            for (int i = 0; i < segments.length; ++i) {
                current = current.getChild(segments[i]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] split() {
        Class<Path> clazz = Path.class;
        synchronized (Path.class) {
            int n = 0;
            Path p = this;
            while (p != sRoot) {
                ++n;
                p = p.mParent;
            }
            String[] segments = new String[n];
            int i = n - 1;
            Path p2 = this;
            while (p2 != sRoot) {
                segments[i--] = p2.mSegment;
                p2 = p2.mParent;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return segments;
        }
    }

    public static String[] split(String s) {
        int n = s.length();
        if (n == 0) {
            return new String[0];
        }
        if (s.charAt(0) != '/') {
            throw new RuntimeException("malformed path:" + s);
        }
        ArrayList<String> segments = new ArrayList<String>();
        int i = 1;
        while (i < n) {
            int j;
            int brace = 0;
            for (j = i; j < n; ++j) {
                char c = s.charAt(j);
                if (c == '{') {
                    ++brace;
                    continue;
                }
                if (c == '}') {
                    --brace;
                    continue;
                }
                if (brace == 0 && c == '/') break;
            }
            if (brace != 0) {
                throw new RuntimeException("unbalanced brace in path:" + s);
            }
            segments.add(s.substring(i, j));
            i = j + 1;
        }
        String[] result = new String[segments.size()];
        segments.toArray(result);
        return result;
    }

    public static String[] splitSequence(String s) {
        int n = s.length();
        if (s.charAt(0) != '{' || s.charAt(n - 1) != '}') {
            throw new RuntimeException("bad sequence: " + s);
        }
        ArrayList<String> segments = new ArrayList<String>();
        int i = 1;
        while (i < n - 1) {
            int j;
            int brace = 0;
            for (j = i; j < n - 1; ++j) {
                char c = s.charAt(j);
                if (c == '{') {
                    ++brace;
                    continue;
                }
                if (c == '}') {
                    --brace;
                    continue;
                }
                if (brace == 0 && c == ',') break;
            }
            if (brace != 0) {
                throw new RuntimeException("unbalanced brace in path:" + s);
            }
            segments.add(s.substring(i, j));
            i = j + 1;
        }
        String[] result = new String[segments.size()];
        segments.toArray(result);
        return result;
    }

    public String getPrefix() {
        if (this == sRoot) {
            return "";
        }
        return this.getPrefixPath().mSegment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getPrefixPath() {
        Class<Path> clazz = Path.class;
        synchronized (Path.class) {
            Path current = this;
            if (current == sRoot) {
                throw new IllegalStateException();
            }
            while (current.mParent != sRoot) {
                current = current.mParent;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return current;
        }
    }

    public String getSuffix() {
        return this.mSegment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearAll() {
        Class<Path> clazz = Path.class;
        synchronized (Path.class) {
            sRoot = new Path(null, "");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static void dumpAll() {
        Path.dumpAll(sRoot, "", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dumpAll(Path p, String prefix1, String prefix2) {
        Class<Path> clazz = Path.class;
        synchronized (Path.class) {
            MediaObject obj = p.getObject();
            Log.d((String)TAG, (String)(prefix1 + p.mSegment + ":" + (obj == null ? "null" : obj.getClass().getSimpleName())));
            if (p.mChildren != null) {
                ArrayList<String> childrenKeys = p.mChildren.keys();
                int i = 0;
                int n = childrenKeys.size();
                for (String key : childrenKeys) {
                    Path child = p.mChildren.get(key);
                    if (child == null) {
                        ++i;
                        continue;
                    }
                    Log.d((String)TAG, (String)(prefix2 + "|"));
                    if (++i < n) {
                        Path.dumpAll(child, prefix2 + "+-- ", prefix2 + "|   ");
                        continue;
                    }
                    Path.dumpAll(child, prefix2 + "+-- ", prefix2 + "    ");
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }
}

