/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.content.Context;
import android.content.res.Resources;
import deviceinfo.mayur.medialibrary.R;
import deviceinfo.mayur.medialibrary.data.Clustering;
import deviceinfo.mayur.medialibrary.data.MediaItem;
import deviceinfo.mayur.medialibrary.data.MediaSet;
import deviceinfo.mayur.medialibrary.data.Path;
import java.util.ArrayList;

public class SizeClustering
extends Clustering {
    private static final String TAG = "SizeClustering";
    private Context mContext;
    private ArrayList<Path>[] mClusters;
    private String[] mNames;
    private long[] mMinSizes;
    private static final long MEGA_BYTES = 0x100000L;
    private static final long GIGA_BYTES = 0x40000000L;
    private static final long[] SIZE_LEVELS = new long[]{0L, 0x100000L, 0xA00000L, 0x6400000L, 0x40000000L, 0x80000000L, 0x100000000L};

    public SizeClustering(Context context) {
        this.mContext = context;
    }

    @Override
    public void run(MediaSet baseSet) {
        final ArrayList[] group = new ArrayList[SIZE_LEVELS.length];
        baseSet.enumerateTotalMediaItems(new MediaSet.ItemConsumer(){

            @Override
            public void consume(int index, MediaItem item) {
                int i;
                long size = item.getSize();
                for (i = 0; i < SIZE_LEVELS.length - 1 && size >= SIZE_LEVELS[i + 1]; ++i) {
                }
                ArrayList<Path> list = group[i];
                if (list == null) {
                    group[i] = list = new ArrayList<Path>();
                }
                list.add(item.getPath());
            }
        });
        int count = 0;
        for (int i = 0; i < group.length; ++i) {
            if (group[i] == null) continue;
            ++count;
        }
        this.mClusters = new ArrayList[count];
        this.mNames = new String[count];
        this.mMinSizes = new long[count];
        Resources res = this.mContext.getResources();
        int k = 0;
        for (int i = group.length - 1; i >= 0; --i) {
            if (group[i] == null) continue;
            this.mClusters[k] = group[i];
            if (i == 0) {
                this.mNames[k] = String.format(res.getString(R.string.size_below), this.getSizeString(i + 1));
            } else if (i == group.length - 1) {
                this.mNames[k] = String.format(res.getString(R.string.size_above), this.getSizeString(i));
            } else {
                String minSize = this.getSizeString(i);
                String maxSize = this.getSizeString(i + 1);
                this.mNames[k] = String.format(res.getString(R.string.size_between), minSize, maxSize);
            }
            this.mMinSizes[k] = SIZE_LEVELS[i];
            ++k;
        }
    }

    private String getSizeString(int index) {
        long bytes = SIZE_LEVELS[index];
        if (bytes >= 0x40000000L) {
            return bytes / 0x40000000L + "GB";
        }
        return bytes / 0x100000L + "MB";
    }

    @Override
    public int getNumberOfClusters() {
        return this.mClusters.length;
    }

    @Override
    public ArrayList<Path> getCluster(int index) {
        return this.mClusters[index];
    }

    @Override
    public String getClusterName(int index) {
        return this.mNames[index];
    }

    public long getMinSize(int index) {
        return this.mMinSizes[index];
    }
}

