/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.graphics.Bitmap;
import android.support.v4.util.Pools;
import android.util.SparseArray;

public class SparseArrayBitmapPool {
    private int mCapacityBytes;
    private SparseArray<Node> mStore = new SparseArray();
    private int mSizeBytes = 0;
    private Pools.Pool<Node> mNodePool;
    private Node mPoolNodesHead = null;
    private Node mPoolNodesTail = null;

    public SparseArrayBitmapPool(int capacityBytes, Pools.Pool<Node> nodePool) {
        this.mCapacityBytes = capacityBytes;
        this.mNodePool = nodePool == null ? new Pools.SimplePool(32) : nodePool;
    }

    public synchronized void setCapacity(int capacityBytes) {
        this.mCapacityBytes = capacityBytes;
        this.freeUpCapacity(0);
    }

    private void freeUpCapacity(int bytesNeeded) {
        int targetSize = this.mCapacityBytes - bytesNeeded;
        while (this.mPoolNodesTail != null && this.mSizeBytes > targetSize) {
            this.unlinkAndRecycleNode(this.mPoolNodesTail, true);
        }
    }

    private void unlinkAndRecycleNode(Node n, boolean recycleBitmap) {
        if (n.prevInBucket != null) {
            n.prevInBucket.nextInBucket = n.nextInBucket;
        } else {
            this.mStore.put(n.bitmap.getWidth(), (Object)n.nextInBucket);
        }
        if (n.nextInBucket != null) {
            n.nextInBucket.prevInBucket = n.prevInBucket;
        }
        if (n.prevInPool != null) {
            n.prevInPool.nextInPool = n.nextInPool;
        } else {
            this.mPoolNodesHead = n.nextInPool;
        }
        if (n.nextInPool != null) {
            n.nextInPool.prevInPool = n.prevInPool;
        } else {
            this.mPoolNodesTail = n.prevInPool;
        }
        n.nextInBucket = null;
        n.nextInPool = null;
        n.prevInBucket = null;
        n.prevInPool = null;
        this.mSizeBytes -= n.bitmap.getByteCount();
        if (recycleBitmap) {
            n.bitmap.recycle();
        }
        n.bitmap = null;
        this.mNodePool.release((Object)n);
    }

    public synchronized int getCapacity() {
        return this.mCapacityBytes;
    }

    public synchronized int getSize() {
        return this.mSizeBytes;
    }

    public synchronized Bitmap get(int width, int height) {
        Node cur = (Node)this.mStore.get(width);
        while (cur != null) {
            if (cur.bitmap.getHeight() == height) {
                Bitmap b = cur.bitmap;
                this.unlinkAndRecycleNode(cur, false);
                return b;
            }
            cur = cur.nextInBucket;
        }
        return null;
    }

    public synchronized boolean put(Bitmap b) {
        if (b == null) {
            return false;
        }
        int bytes = b.getByteCount();
        this.freeUpCapacity(bytes);
        Node newNode = (Node)this.mNodePool.acquire();
        if (newNode == null) {
            newNode = new Node();
        }
        newNode.bitmap = b;
        newNode.prevInBucket = null;
        newNode.prevInPool = null;
        newNode.nextInPool = this.mPoolNodesHead;
        this.mPoolNodesHead = newNode;
        int key = b.getWidth();
        newNode.nextInBucket = (Node)this.mStore.get(key);
        if (newNode.nextInBucket != null) {
            newNode.nextInBucket.prevInBucket = newNode;
        }
        this.mStore.put(key, (Object)newNode);
        if (newNode.nextInPool == null) {
            this.mPoolNodesTail = newNode;
        } else {
            newNode.nextInPool.prevInPool = newNode;
        }
        this.mSizeBytes += bytes;
        return true;
    }

    public synchronized void clear() {
        this.freeUpCapacity(this.mCapacityBytes);
    }

    protected static class Node {
        Bitmap bitmap;
        Node prevInBucket;
        Node nextInBucket;
        Node nextInPool;
        Node prevInPool;

        protected Node() {
        }
    }
}

