/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.content.Context;
import deviceinfo.mayur.medialibrary.R;
import deviceinfo.mayur.medialibrary.data.Clustering;
import deviceinfo.mayur.medialibrary.data.MediaItem;
import deviceinfo.mayur.medialibrary.data.MediaSet;
import deviceinfo.mayur.medialibrary.data.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class TagClustering
extends Clustering {
    private static final String TAG = "TagClustering";
    private ArrayList<ArrayList<Path>> mClusters;
    private String[] mNames;
    private String mUntaggedString;

    public TagClustering(Context context) {
        this.mUntaggedString = context.getResources().getString(R.string.untagged);
    }

    @Override
    public void run(MediaSet baseSet) {
        final TreeMap map = new TreeMap();
        final ArrayList untagged = new ArrayList();
        baseSet.enumerateTotalMediaItems(new MediaSet.ItemConsumer(){

            @Override
            public void consume(int index, MediaItem item) {
                Path path = item.getPath();
                String[] tags = item.getTags();
                if (tags == null || tags.length == 0) {
                    untagged.add(path);
                    return;
                }
                for (int j = 0; j < tags.length; ++j) {
                    String key = tags[j];
                    ArrayList<Path> list = (ArrayList<Path>)map.get(key);
                    if (list == null) {
                        list = new ArrayList<Path>();
                        map.put(key, list);
                    }
                    list.add(path);
                }
            }
        });
        int m = map.size();
        this.mClusters = new ArrayList();
        this.mNames = new String[m + (untagged.size() > 0 ? 1 : 0)];
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            this.mNames[i++] = (String)entry.getKey();
            this.mClusters.add((ArrayList<Path>)entry.getValue());
        }
        if (untagged.size() > 0) {
            this.mNames[i++] = this.mUntaggedString;
            this.mClusters.add(untagged);
        }
    }

    @Override
    public int getNumberOfClusters() {
        return this.mClusters.size();
    }

    @Override
    public ArrayList<Path> getCluster(int index) {
        return this.mClusters.get(index);
    }

    @Override
    public String getClusterName(int index) {
        return this.mNames[index];
    }
}

