/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.data;

import android.content.Context;
import deviceinfo.mayur.medialibrary.data.Cluster;
import deviceinfo.mayur.medialibrary.data.Clustering;
import deviceinfo.mayur.medialibrary.data.MediaItem;
import deviceinfo.mayur.medialibrary.data.MediaSet;
import deviceinfo.mayur.medialibrary.data.Path;
import deviceinfo.mayur.medialibrary.data.SmallItem;
import deviceinfo.mayur.medialibrary.util.GalleryUtils;
import deviceinfo.mayur.medialibrary.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class TimeClustering
extends Clustering {
    private static final String TAG = "TimeClustering";
    private static final int GEOGRAPHIC_DISTANCE_CUTOFF_IN_MILES = 20;
    private static final long MIN_CLUSTER_SPLIT_TIME_IN_MS = 60000L;
    private static final long MAX_CLUSTER_SPLIT_TIME_IN_MS = 0x6DDD00L;
    private static final int NUM_CLUSTERS_TARGETED = 9;
    private static final int MIN_MIN_CLUSTER_SIZE = 8;
    private static final int MAX_MIN_CLUSTER_SIZE = 15;
    private static final int MIN_MAX_CLUSTER_SIZE = 20;
    private static final int MAX_MAX_CLUSTER_SIZE = 50;
    private static int CLUSTER_SPLIT_MULTIPLIER = 3;
    private static final int MIN_PARTITION_CHANGE_FACTOR = 2;
    private static final int PARTITION_CLUSTER_SPLIT_TIME_FACTOR = 2;
    private Context mContext;
    private ArrayList<Cluster> mClusters;
    private String[] mNames;
    private Cluster mCurrCluster;
    private long mClusterSplitTime = 3630000L;
    private long mLargeClusterSplitTime = this.mClusterSplitTime / 2L;
    private int mMinClusterSize = 11;
    private int mMaxClusterSize = 35;
    private static final Comparator<SmallItem> sDateComparator = new DateComparator();

    public TimeClustering(Context context) {
        this.mContext = context;
        this.mClusters = new ArrayList();
        this.mCurrCluster = new Cluster();
    }

    @Override
    public void run(MediaSet baseSet) {
        int i;
        final int total = baseSet.getTotalMediaItemCount();
        final SmallItem[] buf = new SmallItem[total];
        final double[] latLng = new double[2];
        baseSet.enumerateTotalMediaItems(new MediaSet.ItemConsumer(){

            @Override
            public void consume(int index, MediaItem item) {
                if (index < 0 || index >= total) {
                    return;
                }
                SmallItem s = new SmallItem();
                s.path = item.getPath();
                s.dateInMs = item.getDateInMs();
                item.getLatLong(latLng);
                s.lat = latLng[0];
                s.lng = latLng[1];
                buf[index] = s;
            }
        });
        ArrayList<SmallItem> items = new ArrayList<SmallItem>(total);
        for (int i2 = 0; i2 < total; ++i2) {
            if (buf[i2] == null) continue;
            items.add(buf[i2]);
        }
        Collections.sort(items, sDateComparator);
        int n = items.size();
        long minTime = 0L;
        long maxTime = 0L;
        for (i = 0; i < n; ++i) {
            long t = ((SmallItem)items.get((int)i)).dateInMs;
            if (t == 0L) continue;
            if (minTime == 0L) {
                minTime = maxTime = t;
                continue;
            }
            minTime = Math.min(minTime, t);
            maxTime = Math.max(maxTime, t);
        }
        this.setTimeRange(maxTime - minTime, n);
        for (i = 0; i < n; ++i) {
            this.compute((SmallItem)items.get(i));
        }
        this.compute(null);
        int m = this.mClusters.size();
        this.mNames = new String[m];
        for (int i3 = 0; i3 < m; ++i3) {
            this.mNames[i3] = this.mClusters.get(i3).generateCaption(this.mContext);
        }
    }

    @Override
    public int getNumberOfClusters() {
        return this.mClusters.size();
    }

    @Override
    public ArrayList<Path> getCluster(int index) {
        ArrayList<SmallItem> items = this.mClusters.get(index).getItems();
        ArrayList<Path> result = new ArrayList<Path>(items.size());
        int n = items.size();
        for (int i = 0; i < n; ++i) {
            result.add(items.get((int)i).path);
        }
        return result;
    }

    @Override
    public String getClusterName(int index) {
        return this.mNames[index];
    }

    private void setTimeRange(long timeRange, int numItems) {
        if (numItems != 0) {
            int meanItemsPerCluster = numItems / 9;
            this.mMinClusterSize = meanItemsPerCluster / 2;
            this.mMaxClusterSize = meanItemsPerCluster * 2;
            this.mClusterSplitTime = timeRange / (long)numItems * (long)CLUSTER_SPLIT_MULTIPLIER;
        }
        this.mClusterSplitTime = Utils.clamp(this.mClusterSplitTime, 60000L, 0x6DDD00L);
        this.mLargeClusterSplitTime = this.mClusterSplitTime / 2L;
        this.mMinClusterSize = Utils.clamp(this.mMinClusterSize, 8, 15);
        this.mMaxClusterSize = Utils.clamp(this.mMaxClusterSize, 20, 50);
    }

    private void compute(SmallItem currentItem) {
        if (currentItem != null) {
            int numClusters = this.mClusters.size();
            int numCurrClusterItems = this.mCurrCluster.size();
            boolean geographicallySeparateItem = false;
            boolean itemAddedToCurrentCluster = false;
            if (numCurrClusterItems == 0) {
                this.mCurrCluster.addItem(currentItem);
            } else {
                SmallItem prevItem = this.mCurrCluster.getLastItem();
                if (TimeClustering.isGeographicallySeparated(prevItem, currentItem)) {
                    this.mClusters.add(this.mCurrCluster);
                    geographicallySeparateItem = true;
                } else if (numCurrClusterItems > this.mMaxClusterSize) {
                    this.splitAndAddCurrentCluster();
                } else if (TimeClustering.timeDistance(prevItem, currentItem) < this.mClusterSplitTime) {
                    this.mCurrCluster.addItem(currentItem);
                    itemAddedToCurrentCluster = true;
                } else if (numClusters > 0 && numCurrClusterItems < this.mMinClusterSize && !this.mCurrCluster.mGeographicallySeparatedFromPrevCluster) {
                    this.mergeAndAddCurrentCluster();
                } else {
                    this.mClusters.add(this.mCurrCluster);
                }
                if (!itemAddedToCurrentCluster) {
                    this.mCurrCluster = new Cluster();
                    if (geographicallySeparateItem) {
                        this.mCurrCluster.mGeographicallySeparatedFromPrevCluster = true;
                    }
                    this.mCurrCluster.addItem(currentItem);
                }
            }
        } else if (this.mCurrCluster.size() > 0) {
            int numClusters = this.mClusters.size();
            int numCurrClusterItems = this.mCurrCluster.size();
            if (numCurrClusterItems > this.mMaxClusterSize) {
                this.splitAndAddCurrentCluster();
            } else if (numClusters > 0 && numCurrClusterItems < this.mMinClusterSize && !this.mCurrCluster.mGeographicallySeparatedFromPrevCluster) {
                this.mergeAndAddCurrentCluster();
            } else {
                this.mClusters.add(this.mCurrCluster);
            }
            this.mCurrCluster = new Cluster();
        }
    }

    private void splitAndAddCurrentCluster() {
        ArrayList<SmallItem> currClusterItems = this.mCurrCluster.getItems();
        int numCurrClusterItems = this.mCurrCluster.size();
        int secondPartitionStartIndex = this.getPartitionIndexForCurrentCluster();
        if (secondPartitionStartIndex != -1) {
            int j;
            Cluster partitionedCluster = new Cluster();
            for (j = 0; j < secondPartitionStartIndex; ++j) {
                partitionedCluster.addItem(currClusterItems.get(j));
            }
            this.mClusters.add(partitionedCluster);
            partitionedCluster = new Cluster();
            for (j = secondPartitionStartIndex; j < numCurrClusterItems; ++j) {
                partitionedCluster.addItem(currClusterItems.get(j));
            }
            this.mClusters.add(partitionedCluster);
        } else {
            this.mClusters.add(this.mCurrCluster);
        }
    }

    private int getPartitionIndexForCurrentCluster() {
        int minClusterSize;
        int partitionIndex = -1;
        float largestChange = 2.0f;
        ArrayList<SmallItem> currClusterItems = this.mCurrCluster.getItems();
        int numCurrClusterItems = this.mCurrCluster.size();
        if (numCurrClusterItems > (minClusterSize = this.mMinClusterSize) + 1) {
            for (int i = minClusterSize; i < numCurrClusterItems - minClusterSize; ++i) {
                long diff2;
                long diff1;
                float change;
                SmallItem prevItem = currClusterItems.get(i - 1);
                SmallItem currItem = currClusterItems.get(i);
                SmallItem nextItem = currClusterItems.get(i + 1);
                long timeNext = nextItem.dateInMs;
                long timeCurr = currItem.dateInMs;
                long timePrev = prevItem.dateInMs;
                if (timeNext == 0L || timeCurr == 0L || timePrev == 0L || !((change = Math.max((float)(diff1 = Math.abs(timeNext - timeCurr)) / ((float)(diff2 = Math.abs(timeCurr - timePrev)) + 0.01f), (float)diff2 / ((float)diff1 + 0.01f))) > largestChange)) continue;
                if (TimeClustering.timeDistance(currItem, prevItem) > this.mLargeClusterSplitTime) {
                    partitionIndex = i;
                    largestChange = change;
                    continue;
                }
                if (TimeClustering.timeDistance(nextItem, currItem) <= this.mLargeClusterSplitTime) continue;
                partitionIndex = i + 1;
                largestChange = change;
            }
        }
        return partitionIndex;
    }

    private void mergeAndAddCurrentCluster() {
        int numClusters = this.mClusters.size();
        Cluster prevCluster = this.mClusters.get(numClusters - 1);
        ArrayList<SmallItem> currClusterItems = this.mCurrCluster.getItems();
        int numCurrClusterItems = this.mCurrCluster.size();
        if (prevCluster.size() < this.mMinClusterSize) {
            for (int i = 0; i < numCurrClusterItems; ++i) {
                prevCluster.addItem(currClusterItems.get(i));
            }
            this.mClusters.set(numClusters - 1, prevCluster);
        } else {
            this.mClusters.add(this.mCurrCluster);
        }
    }

    private static boolean isGeographicallySeparated(SmallItem itemA, SmallItem itemB) {
        if (!GalleryUtils.isValidLocation(itemA.lat, itemA.lng) || !GalleryUtils.isValidLocation(itemB.lat, itemB.lng)) {
            return false;
        }
        double distance = GalleryUtils.fastDistanceMeters(Math.toRadians(itemA.lat), Math.toRadians(itemA.lng), Math.toRadians(itemB.lat), Math.toRadians(itemB.lng));
        return GalleryUtils.toMile(distance) > 20.0;
    }

    private static long timeDistance(SmallItem a, SmallItem b) {
        return Math.abs(a.dateInMs - b.dateInMs);
    }

    private static class DateComparator
    implements Comparator<SmallItem> {
        private DateComparator() {
        }

        @Override
        public int compare(SmallItem item1, SmallItem item2) {
            return -Utils.compare(item1.dateInMs, item2.dateInMs);
        }
    }
}

