/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.os.Build;
import android.util.Log;
import deviceinfo.mayur.medialibrary.util.Utils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BitmapUtils {
    private static final String TAG = "BitmapUtils";
    private static final int DEFAULT_JPEG_QUALITY = 90;
    public static final int UNCONSTRAINED = -1;

    private BitmapUtils() {
    }

    public static int computeSampleSize(int width, int height, int minSideLength, int maxNumOfPixels) {
        int initialSize = BitmapUtils.computeInitialSampleSize(width, height, minSideLength, maxNumOfPixels);
        return initialSize <= 8 ? Utils.nextPowerOf2(initialSize) : (initialSize + 7) / 8 * 8;
    }

    private static int computeInitialSampleSize(int w, int h, int minSideLength, int maxNumOfPixels) {
        int lowerBound;
        if (maxNumOfPixels == -1 && minSideLength == -1) {
            return 1;
        }
        int n = lowerBound = maxNumOfPixels == -1 ? 1 : (int)Math.ceil(Math.sqrt((double)(w * h) / (double)maxNumOfPixels));
        if (minSideLength == -1) {
            return lowerBound;
        }
        int sampleSize = Math.min(w / minSideLength, h / minSideLength);
        return Math.max(sampleSize, lowerBound);
    }

    public static int computeSampleSizeLarger(int w, int h, int minSideLength) {
        int initialSize = Math.max(w / minSideLength, h / minSideLength);
        if (initialSize <= 1) {
            return 1;
        }
        return initialSize <= 8 ? Utils.prevPowerOf2(initialSize) : initialSize / 8 * 8;
    }

    public static int computeSampleSizeLarger(float scale) {
        int initialSize = (int)Math.floor(1.0 / (double)scale);
        if (initialSize <= 1) {
            return 1;
        }
        return initialSize <= 8 ? Utils.prevPowerOf2(initialSize) : initialSize / 8 * 8;
    }

    public static int computeSampleSize(float scale) {
        Utils.assertTrue(scale > 0.0f);
        int initialSize = Math.max(1, (int)Math.ceil(1.0f / scale));
        return initialSize <= 8 ? Utils.nextPowerOf2(initialSize) : (initialSize + 7) / 8 * 8;
    }

    public static Bitmap resizeBitmapByScale(Bitmap bitmap, float scale, boolean recycle) {
        int width = Math.round((float)bitmap.getWidth() * scale);
        int height = Math.round((float)bitmap.getHeight() * scale);
        if (width == bitmap.getWidth() && height == bitmap.getHeight()) {
            return bitmap;
        }
        Bitmap target = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)BitmapUtils.getConfig(bitmap));
        Canvas canvas = new Canvas(target);
        canvas.scale(scale, scale);
        Paint paint = new Paint(6);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        if (recycle) {
            bitmap.recycle();
        }
        return target;
    }

    private static Bitmap.Config getConfig(Bitmap bitmap) {
        Bitmap.Config config = bitmap.getConfig();
        if (config == null) {
            config = Bitmap.Config.ARGB_8888;
        }
        return config;
    }

    public static Bitmap resizeDownBySideLength(Bitmap bitmap, int maxLength, boolean recycle) {
        int srcHeight;
        int srcWidth = bitmap.getWidth();
        float scale = Math.min((float)maxLength / (float)srcWidth, (float)maxLength / (float)(srcHeight = bitmap.getHeight()));
        if (scale >= 1.0f) {
            return bitmap;
        }
        return BitmapUtils.resizeBitmapByScale(bitmap, scale, recycle);
    }

    public static Bitmap resizeAndCropCenter(Bitmap bitmap, int size, boolean recycle) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        if (w == size && h == size) {
            return bitmap;
        }
        float scale = (float)size / (float)Math.min(w, h);
        Bitmap target = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)BitmapUtils.getConfig(bitmap));
        int width = Math.round(scale * (float)bitmap.getWidth());
        int height = Math.round(scale * (float)bitmap.getHeight());
        Canvas canvas = new Canvas(target);
        canvas.translate((float)(size - width) / 2.0f, (float)(size - height) / 2.0f);
        canvas.scale(scale, scale);
        Paint paint = new Paint(6);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        if (recycle) {
            bitmap.recycle();
        }
        return target;
    }

    public static void recycleSilently(Bitmap bitmap) {
        if (bitmap == null) {
            return;
        }
        try {
            bitmap.recycle();
        }
        catch (Throwable t) {
            Log.w((String)TAG, (String)"unable recycle bitmap", (Throwable)t);
        }
    }

    public static Bitmap rotateBitmap(Bitmap source, int rotation, boolean recycle) {
        if (rotation == 0) {
            return source;
        }
        int w = source.getWidth();
        int h = source.getHeight();
        Matrix m = new Matrix();
        m.postRotate((float)rotation);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)w, (int)h, (Matrix)m, (boolean)true);
        if (recycle) {
            source.recycle();
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Bitmap createVideoThumbnail(String filePath) {
        Class<?> clazz = null;
        Object instance = null;
        try {
            Bitmap bitmap;
            clazz = Class.forName("android.media.MediaMetadataRetriever");
            instance = clazz.newInstance();
            Method method = clazz.getMethod("setDataSource", String.class);
            method.invoke(instance, filePath);
            if (Build.VERSION.SDK_INT <= 9) {
                Bitmap bitmap2 = (Bitmap)clazz.getMethod("captureFrame", new Class[0]).invoke(instance, new Object[0]);
                return bitmap2;
            }
            byte[] data = (byte[])clazz.getMethod("getEmbeddedPicture", new Class[0]).invoke(instance, new Object[0]);
            if (data != null && (bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length)) != null) {
                Bitmap bitmap3 = bitmap;
                return bitmap3;
            }
            Bitmap bitmap4 = (Bitmap)clazz.getMethod("getFrameAtTime", new Class[0]).invoke(instance, new Object[0]);
            return bitmap4;
        }
        catch (IllegalArgumentException method) {
            return null;
        }
        catch (RuntimeException method) {
            return null;
        }
        catch (InstantiationException e) {
            Log.e((String)TAG, (String)"createVideoThumbnail", (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            Log.e((String)TAG, (String)"createVideoThumbnail", (Throwable)e);
            return null;
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)"createVideoThumbnail", (Throwable)e);
            return null;
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)"createVideoThumbnail", (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)"createVideoThumbnail", (Throwable)e);
            return null;
        }
        finally {
            try {
                if (instance != null) {
                    clazz.getMethod("release", new Class[0]).invoke(instance, new Object[0]);
                }
            }
            catch (Exception e) {}
        }
    }

    public static byte[] compressToBytes(Bitmap bitmap) {
        return BitmapUtils.compressToBytes(bitmap, 90);
    }

    public static byte[] compressToBytes(Bitmap bitmap, int quality) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(65536);
        bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static boolean isSupportedByRegionDecoder(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return (mimeType = mimeType.toLowerCase()).startsWith("image/") && !mimeType.equals("image/gif") && !mimeType.endsWith("bmp");
    }

    public static boolean isRotationSupported(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        mimeType = mimeType.toLowerCase();
        return mimeType.equals("image/jpeg");
    }
}

