/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.util.Log;
import deviceinfo.mayur.medialibrary.util.BlobCache;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class CacheManager {
    private static final String TAG = "CacheManager";
    private static final String KEY_CACHE_UP_TO_DATE = "cache-up-to-date";
    private static HashMap<String, BlobCache> sCacheMap = new HashMap();
    private static boolean sOldCheckDone = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlobCache getCache(Context context, String filename, int maxEntries, int maxBytes, int version) {
        HashMap<String, BlobCache> hashMap = sCacheMap;
        synchronized (hashMap) {
            BlobCache cache;
            if (!sOldCheckDone) {
                CacheManager.removeOldFilesIfNecessary(context);
                sOldCheckDone = true;
            }
            if ((cache = sCacheMap.get(filename)) == null) {
                File cacheDir = context.getExternalCacheDir();
                String path = cacheDir.getAbsolutePath() + "/" + filename;
                try {
                    cache = new BlobCache(path, maxEntries, maxBytes, false, version);
                    sCacheMap.put(filename, cache);
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Cannot instantiate cache!", (Throwable)e);
                }
            }
            return cache;
        }
    }

    private static void removeOldFilesIfNecessary(Context context) {
        SharedPreferences pref = PreferenceManager.getDefaultSharedPreferences((Context)context);
        int n = 0;
        try {
            n = pref.getInt(KEY_CACHE_UP_TO_DATE, 0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (n != 0) {
            return;
        }
        pref.edit().putInt(KEY_CACHE_UP_TO_DATE, 1).commit();
        File cacheDir = context.getExternalCacheDir();
        String prefix = cacheDir.getAbsolutePath() + "/";
        BlobCache.deleteFiles(prefix + "imgcache");
        BlobCache.deleteFiles(prefix + "rev_geocoding");
        BlobCache.deleteFiles(prefix + "bookmark");
    }
}

