/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.util;

import deviceinfo.mayur.medialibrary.data.Path;

public class FilterUtils {
    private static final String TAG = "FilterUtils";
    public static final int CLUSTER_BY_ALBUM = 1;
    public static final int CLUSTER_BY_TIME = 2;
    public static final int CLUSTER_BY_LOCATION = 4;
    public static final int CLUSTER_BY_TAG = 8;
    public static final int CLUSTER_BY_SIZE = 16;
    public static final int CLUSTER_BY_FACE = 32;
    public static final int FILTER_IMAGE_ONLY = 1;
    public static final int FILTER_VIDEO_ONLY = 2;
    public static final int FILTER_ALL = 4;
    private static final int CLUSTER_TYPE = 0;
    private static final int FILTER_TYPE = 1;
    private static final int CLUSTER_TYPE_F = 2;
    private static final int FILTER_TYPE_F = 3;
    private static final int CLUSTER_CURRENT_TYPE = 4;
    private static final int FILTER_CURRENT_TYPE = 5;

    private static void getAppliedFilters(Path path, int[] result) {
        FilterUtils.getAppliedFilters(path, result, false);
    }

    private static void getAppliedFilters(Path path, int[] result, boolean underCluster) {
        String[] segments = path.split();
        for (int i = 0; i < segments.length; ++i) {
            if (!segments[i].startsWith("{")) continue;
            String[] sets = Path.splitSequence(segments[i]);
            for (int j = 0; j < sets.length; ++j) {
                Path sub = Path.fromString(sets[j]);
                FilterUtils.getAppliedFilters(sub, result, underCluster);
            }
        }
        if (segments[0].equals("cluster")) {
            if (segments.length == 4) {
                underCluster = true;
            }
            int ctype = FilterUtils.toClusterType(segments[2]);
            result[0] = result[0] | ctype;
            result[4] = ctype;
            if (underCluster) {
                result[2] = result[2] | ctype;
            }
        }
    }

    private static int toClusterType(String s) {
        if (s.equals("time")) {
            return 2;
        }
        if (s.equals("location")) {
            return 4;
        }
        if (s.equals("tag")) {
            return 8;
        }
        if (s.equals("size")) {
            return 16;
        }
        if (s.equals("face")) {
            return 32;
        }
        return 0;
    }

    public static String newFilterPath(String base, int filterType) {
        int mediaType;
        switch (filterType) {
            case 1: {
                mediaType = 2;
                break;
            }
            case 2: {
                mediaType = 4;
                break;
            }
            default: {
                return base;
            }
        }
        return "/filter/mediatype/" + mediaType + "/{" + base + "}";
    }

    public static String newClusterPath(String base, int clusterType) {
        String kind;
        switch (clusterType) {
            case 2: {
                kind = "time";
                break;
            }
            case 4: {
                kind = "location";
                break;
            }
            case 8: {
                kind = "tag";
                break;
            }
            case 16: {
                kind = "size";
                break;
            }
            case 32: {
                kind = "face";
                break;
            }
            default: {
                return base;
            }
        }
        return "/cluster/{" + base + "}/" + kind;
    }

    public static String switchClusterPath(String base, int clusterType) {
        return FilterUtils.newClusterPath(FilterUtils.removeOneClusterFromPath(base), clusterType);
    }

    private static String removeOneClusterFromPath(String base) {
        boolean[] done = new boolean[1];
        return FilterUtils.removeOneClusterFromPath(base, done);
    }

    private static String removeOneClusterFromPath(String base, boolean[] done) {
        if (done[0]) {
            return base;
        }
        String[] segments = Path.split(base);
        if (segments[0].equals("cluster")) {
            done[0] = true;
            return Path.splitSequence(segments[1])[0];
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < segments.length; ++i) {
            sb.append("/");
            if (segments[i].startsWith("{")) {
                sb.append("{");
                String[] sets = Path.splitSequence(segments[i]);
                for (int j = 0; j < sets.length; ++j) {
                    if (j > 0) {
                        sb.append(",");
                    }
                    sb.append(FilterUtils.removeOneClusterFromPath(sets[j], done));
                }
                sb.append("}");
                continue;
            }
            sb.append(segments[i]);
        }
        return sb.toString();
    }
}

