/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.util;

import android.annotation.TargetApi;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Color;
import android.net.Uri;
import android.os.ConditionVariable;
import android.os.Environment;
import android.os.StatFs;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import deviceinfo.mayur.medialibrary.R;
import deviceinfo.mayur.medialibrary.data.MediaItem;
import deviceinfo.mayur.medialibrary.util.ApiHelper;
import deviceinfo.mayur.medialibrary.util.ThreadPool;
import java.io.File;
import java.util.Arrays;
import java.util.Locale;

public class GalleryUtils {
    private static final String TAG = "GalleryUtils";
    private static final String MAPS_PACKAGE_NAME = "com.google.android.apps.maps";
    private static final String MAPS_CLASS_NAME = "com.google.android.maps.MapsActivity";
    private static final String CAMERA_LAUNCHER_NAME = "com.android.camera.CameraLauncher";
    public static final String MIME_TYPE_IMAGE = "image/*";
    public static final String MIME_TYPE_VIDEO = "video/*";
    public static final String MIME_TYPE_PANORAMA360 = "application/vnd.google.panorama360+jpg";
    public static final String MIME_TYPE_ALL = "*/*";
    private static final String DIR_TYPE_IMAGE = "vnd.android.cursor.dir/image";
    private static final String DIR_TYPE_VIDEO = "vnd.android.cursor.dir/video";
    private static final String PREFIX_PHOTO_EDITOR_UPDATE = "editor-update-";
    private static final String PREFIX_HAS_PHOTO_EDITOR = "has-editor-";
    private static final String KEY_CAMERA_UPDATE = "camera-update";
    private static final String KEY_HAS_CAMERA = "has-camera";
    private static float sPixelDensity = -1.0f;
    private static boolean sCameraAvailableInitialized = false;
    private static boolean sCameraAvailable;
    private static volatile Thread sCurrentThread;
    private static volatile boolean sWarned;
    private static final double RAD_PER_DEG = Math.PI / 180;
    private static final double EARTH_RADIUS_METERS = 6367000.0;

    public static void initialize(Context context) {
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
        sPixelDensity = metrics.density;
        Resources r = context.getResources();
    }

    public static float[] intColorToFloatARGBArray(int from) {
        return new float[]{(float)Color.alpha((int)from) / 255.0f, (float)Color.red((int)from) / 255.0f, (float)Color.green((int)from) / 255.0f, (float)Color.blue((int)from) / 255.0f};
    }

    public static float dpToPixel(float dp) {
        return sPixelDensity * dp;
    }

    public static int dpToPixel(int dp) {
        return Math.round(GalleryUtils.dpToPixel((float)dp));
    }

    public static int meterToPixel(float meter) {
        return Math.round(GalleryUtils.dpToPixel(meter * 39.37f * 160.0f));
    }

    public static byte[] getBytes(String in) {
        byte[] result = new byte[in.length() * 2];
        int output = 0;
        for (char ch : in.toCharArray()) {
            result[output++] = (byte)(ch & 0xFF);
            result[output++] = (byte)(ch >> 8);
        }
        return result;
    }

    public static void setRenderThread() {
        sCurrentThread = Thread.currentThread();
    }

    public static void assertNotInRenderThread() {
        if (!sWarned && Thread.currentThread() == sCurrentThread) {
            sWarned = true;
            Log.w((String)TAG, (Throwable)new Throwable("Should not do this in render thread"));
        }
    }

    public static double fastDistanceMeters(double latRad1, double lngRad1, double latRad2, double lngRad2) {
        if (Math.abs(latRad1 - latRad2) > Math.PI / 180 || Math.abs(lngRad1 - lngRad2) > Math.PI / 180) {
            return GalleryUtils.accurateDistanceMeters(latRad1, lngRad1, latRad2, lngRad2);
        }
        double sineLat = latRad1 - latRad2;
        double sineLng = lngRad1 - lngRad2;
        double cosTerms = Math.cos((latRad1 + latRad2) / 2.0);
        cosTerms *= cosTerms;
        double trigTerm = sineLat * sineLat + cosTerms * sineLng * sineLng;
        trigTerm = Math.sqrt(trigTerm);
        return 6367000.0 * trigTerm;
    }

    public static double accurateDistanceMeters(double lat1, double lng1, double lat2, double lng2) {
        double dlat = Math.sin(0.5 * (lat2 - lat1));
        double dlng = Math.sin(0.5 * (lng2 - lng1));
        double x = dlat * dlat + dlng * dlng * Math.cos(lat1) * Math.cos(lat2);
        return 2.0 * Math.atan2(Math.sqrt(x), Math.sqrt(Math.max(0.0, 1.0 - x))) * 6367000.0;
    }

    public static final double toMile(double meter) {
        return meter / 1609.0;
    }

    public static void fakeBusy(ThreadPool.JobContext jc, int timeout) {
        final ConditionVariable cv = new ConditionVariable();
        jc.setCancelListener(new ThreadPool.CancelListener(){

            @Override
            public void onCancel() {
                cv.open();
            }
        });
        cv.block((long)timeout);
        jc.setCancelListener(null);
    }

    public static void startCameraActivity(Context context) {
        Intent intent = new Intent("android.media.action.STILL_IMAGE_CAMERA").setFlags(0x14000000);
        try {
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Log.e((String)TAG, (String)"Camera activity previously detected but cannot be found", (Throwable)e);
        }
    }

    public static boolean isValidLocation(double latitude, double longitude) {
        return latitude != 0.0 || longitude != 0.0;
    }

    public static String formatLatitudeLongitude(String format, double latitude, double longitude) {
        return String.format(Locale.ENGLISH, format, latitude, longitude);
    }

    public static void showOnMap(Context context, double latitude, double longitude) {
        try {
            String uri = GalleryUtils.formatLatitudeLongitude("http://maps.google.com/maps?f=q&q=(%f,%f)", latitude, longitude);
            ComponentName compName = new ComponentName(MAPS_PACKAGE_NAME, MAPS_CLASS_NAME);
            Intent mapsIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)uri)).setComponent(compName);
            context.startActivity(mapsIntent);
        }
        catch (ActivityNotFoundException e) {
            Log.e((String)TAG, (String)"GMM activity not found!", (Throwable)e);
            String url = GalleryUtils.formatLatitudeLongitude("geo:%f,%f", latitude, longitude);
            Intent mapsIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            context.startActivity(mapsIntent);
        }
    }

    public static void setViewPointMatrix(float[] matrix, float x, float y, float z) {
        Arrays.fill(matrix, 0, 16, 0.0f);
        matrix[5] = matrix[15] = -z;
        matrix[0] = matrix[15];
        matrix[8] = x;
        matrix[9] = y;
        matrix[11] = 1.0f;
        matrix[10] = 1.0f;
    }

    public static int getBucketId(String path) {
        return path.toLowerCase().hashCode();
    }

    public static String searchDirForPath(File dir, int bucketId) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                String path = file.getAbsolutePath();
                if (GalleryUtils.getBucketId(path) == bucketId) {
                    return path;
                }
                path = GalleryUtils.searchDirForPath(file, bucketId);
                if (path == null) continue;
                return path;
            }
        }
        return null;
    }

    public static String formatDuration(Context context, int duration) {
        int h = duration / 3600;
        int m = (duration - h * 3600) / 60;
        int s = duration - (h * 3600 + m * 60);
        String durationValue = h == 0 ? String.format(context.getString(R.string.details_ms), m, s) : String.format(context.getString(R.string.details_hms), h, m, s);
        return durationValue;
    }

    @TargetApi(value=11)
    public static int determineTypeBits(Context context, Intent intent) {
        int typeBits = 0;
        String type = intent.resolveType(context);
        typeBits = MIME_TYPE_ALL.equals(type) ? 3 : (MIME_TYPE_IMAGE.equals(type) || DIR_TYPE_IMAGE.equals(type) ? 1 : (MIME_TYPE_VIDEO.equals(type) || DIR_TYPE_VIDEO.equals(type) ? 2 : 3));
        if (ApiHelper.HAS_INTENT_EXTRA_LOCAL_ONLY && intent.getBooleanExtra("android.intent.extra.LOCAL_ONLY", false)) {
            typeBits |= 4;
        }
        return typeBits;
    }

    public static int getSelectionModePrompt(int typeBits) {
        if ((typeBits & 2) != 0) {
            return (typeBits & 1) == 0 ? R.string.select_video : R.string.select_item;
        }
        return R.string.select_image;
    }

    public static boolean hasSpaceForSize(long size) {
        String state = Environment.getExternalStorageState();
        if (!"mounted".equals(state)) {
            return false;
        }
        String path = Environment.getExternalStorageDirectory().getPath();
        try {
            StatFs stat = new StatFs(path);
            return (long)stat.getAvailableBlocks() * (long)stat.getBlockSize() > size;
        }
        catch (Exception e) {
            Log.i((String)TAG, (String)"Fail to access external storage", (Throwable)e);
            return false;
        }
    }

    public static boolean isPanorama(MediaItem item) {
        if (item == null) {
            return false;
        }
        int w = item.getWidth();
        int h = item.getHeight();
        return h > 0 && w / h >= 2;
    }
}

