/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class IdentityCache<K, V> {
    private final HashMap<K, Entry<K, V>> mWeakMap = new HashMap();
    private ReferenceQueue<V> mQueue = new ReferenceQueue();

    private void cleanUpWeakMap() {
        Entry entry = (Entry)this.mQueue.poll();
        while (entry != null) {
            this.mWeakMap.remove(entry.mKey);
            entry = (Entry)this.mQueue.poll();
        }
    }

    public synchronized V put(K key, V value) {
        this.cleanUpWeakMap();
        Entry<K, V> entry = this.mWeakMap.put(key, new Entry<K, V>(key, value, this.mQueue));
        return entry == null ? null : (V)entry.get();
    }

    public synchronized V get(K key) {
        this.cleanUpWeakMap();
        Entry<K, V> entry = this.mWeakMap.get(key);
        return entry == null ? null : (V)entry.get();
    }

    public synchronized ArrayList<K> keys() {
        Set<K> set = this.mWeakMap.keySet();
        ArrayList<K> result = new ArrayList<K>(set);
        return result;
    }

    private static class Entry<K, V>
    extends WeakReference<V> {
        K mKey;

        public Entry(K key, V value, ReferenceQueue<V> queue) {
            super(value, queue);
            this.mKey = key;
        }
    }
}

