/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.util;

import android.content.Context;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import deviceinfo.mayur.medialibrary.util.BlobCache;
import deviceinfo.mayur.medialibrary.util.CacheManager;
import deviceinfo.mayur.medialibrary.util.GalleryUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

public class ReverseGeocoder {
    private static final String TAG = "ReverseGeocoder";
    public static final int EARTH_RADIUS_METERS = 6378137;
    public static final int LAT_MIN = -90;
    public static final int LAT_MAX = 90;
    public static final int LON_MIN = -180;
    public static final int LON_MAX = 180;
    private static final int MAX_COUNTRY_NAME_LENGTH = 8;
    private static final int MAX_LOCALITY_MILE_RANGE = 20;
    private static final String GEO_CACHE_FILE = "rev_geocoding";
    private static final int GEO_CACHE_MAX_ENTRIES = 1000;
    private static final int GEO_CACHE_MAX_BYTES = 512000;
    private static final int GEO_CACHE_VERSION = 0;
    private Context mContext;
    private Geocoder mGeocoder;
    private BlobCache mGeoCache;
    private ConnectivityManager mConnectivityManager;
    private static Address sCurrentAddress;

    public ReverseGeocoder(Context context) {
        this.mContext = context;
        this.mGeocoder = new Geocoder(this.mContext);
        this.mGeoCache = CacheManager.getCache(context, GEO_CACHE_FILE, 1000, 512000, 0);
        this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
    }

    public String computeAddress(SetLatLong set) {
        double setMinLatitude = set.mMinLatLatitude;
        double setMinLongitude = set.mMinLatLongitude;
        double setMaxLatitude = set.mMaxLatLatitude;
        double setMaxLongitude = set.mMaxLatLongitude;
        if (Math.abs(set.mMaxLatLatitude - set.mMinLatLatitude) < Math.abs(set.mMaxLonLongitude - set.mMinLonLongitude)) {
            setMinLatitude = set.mMinLonLatitude;
            setMinLongitude = set.mMinLonLongitude;
            setMaxLatitude = set.mMaxLonLatitude;
            setMaxLongitude = set.mMaxLonLongitude;
        }
        Address addr1 = this.lookupAddress(setMinLatitude, setMinLongitude, true);
        Address addr2 = this.lookupAddress(setMaxLatitude, setMaxLongitude, true);
        if (addr1 == null) {
            addr1 = addr2;
        }
        if (addr2 == null) {
            addr2 = addr1;
        }
        if (addr1 == null || addr2 == null) {
            return null;
        }
        LocationManager locationManager = (LocationManager)this.mContext.getSystemService("location");
        Location location = null;
        List providers = locationManager.getAllProviders();
        for (int i = 0; i < providers.size(); ++i) {
            String provider = (String)providers.get(i);
            Location location2 = location = provider != null ? locationManager.getLastKnownLocation(provider) : null;
            if (location != null) break;
        }
        String currentCity = "";
        String currentAdminArea = "";
        String currentCountry = Locale.getDefault().getCountry();
        if (location != null) {
            Address currentAddress = this.lookupAddress(location.getLatitude(), location.getLongitude(), true);
            if (currentAddress == null) {
                currentAddress = sCurrentAddress;
            } else {
                sCurrentAddress = currentAddress;
            }
            if (currentAddress != null && currentAddress.getCountryCode() != null) {
                currentCity = this.checkNull(currentAddress.getLocality());
                currentCountry = this.checkNull(currentAddress.getCountryCode());
                currentAdminArea = this.checkNull(currentAddress.getAdminArea());
            }
        }
        String closestCommonLocation = null;
        String addr1Locality = this.checkNull(addr1.getLocality());
        String addr2Locality = this.checkNull(addr2.getLocality());
        String addr1AdminArea = this.checkNull(addr1.getAdminArea());
        String addr2AdminArea = this.checkNull(addr2.getAdminArea());
        String addr1CountryCode = this.checkNull(addr1.getCountryCode());
        String addr2CountryCode = this.checkNull(addr2.getCountryCode());
        if (currentCity.equals(addr1Locality) || currentCity.equals(addr2Locality)) {
            String otherCity = currentCity;
            if (currentCity.equals(addr1Locality)) {
                otherCity = addr2Locality;
                if (otherCity.length() == 0) {
                    otherCity = addr2AdminArea;
                    if (!currentCountry.equals(addr2CountryCode)) {
                        otherCity = otherCity + " " + addr2CountryCode;
                    }
                }
                addr2Locality = addr1Locality;
                addr2AdminArea = addr1AdminArea;
                addr2CountryCode = addr1CountryCode;
            } else {
                otherCity = addr1Locality;
                if (otherCity.length() == 0) {
                    otherCity = addr1AdminArea;
                    if (!currentCountry.equals(addr1CountryCode)) {
                        otherCity = otherCity + " " + addr1CountryCode;
                    }
                }
                addr1Locality = addr2Locality;
                addr1AdminArea = addr2AdminArea;
                addr1CountryCode = addr2CountryCode;
            }
            closestCommonLocation = this.valueIfEqual(addr1.getAddressLine(0), addr2.getAddressLine(0));
            if (closestCommonLocation != null && !"null".equals(closestCommonLocation)) {
                if (!currentCity.equals(otherCity)) {
                    closestCommonLocation = closestCommonLocation + " - " + otherCity;
                }
                return closestCommonLocation;
            }
            closestCommonLocation = this.valueIfEqual(addr1.getThoroughfare(), addr2.getThoroughfare());
            if (closestCommonLocation != null && !"null".equals(closestCommonLocation)) {
                return closestCommonLocation;
            }
        }
        if ((closestCommonLocation = this.valueIfEqual(addr1Locality, addr2Locality)) != null && !"".equals(closestCommonLocation)) {
            String adminArea = addr1AdminArea;
            String countryCode = addr1CountryCode;
            if (adminArea != null && adminArea.length() > 0) {
                closestCommonLocation = !countryCode.equals(currentCountry) ? closestCommonLocation + ", " + adminArea + " " + countryCode : closestCommonLocation + ", " + adminArea;
            }
            return closestCommonLocation;
        }
        if (currentAdminArea.equals(addr1AdminArea) && currentAdminArea.equals(addr2AdminArea)) {
            if ("".equals(addr1Locality)) {
                addr1Locality = addr2Locality;
            }
            if ("".equals(addr2Locality)) {
                addr2Locality = addr1Locality;
            }
            if (!"".equals(addr1Locality)) {
                closestCommonLocation = addr1Locality.equals(addr2Locality) ? addr1Locality + ", " + currentAdminArea : addr1Locality + " - " + addr2Locality;
                return closestCommonLocation;
            }
        }
        float[] distanceFloat = new float[1];
        Location.distanceBetween((double)setMinLatitude, (double)setMinLongitude, (double)setMaxLatitude, (double)setMaxLongitude, (float[])distanceFloat);
        int distance = (int)GalleryUtils.toMile(distanceFloat[0]);
        if (distance < 20) {
            closestCommonLocation = this.getLocalityAdminForAddress(addr1, true);
            if (closestCommonLocation != null) {
                return closestCommonLocation;
            }
            closestCommonLocation = this.getLocalityAdminForAddress(addr2, true);
            if (closestCommonLocation != null) {
                return closestCommonLocation;
            }
        }
        if ((closestCommonLocation = this.valueIfEqual(addr1AdminArea, addr2AdminArea)) != null && !"".equals(closestCommonLocation)) {
            String countryCode = addr1CountryCode;
            if (!countryCode.equals(currentCountry) && countryCode != null && countryCode.length() > 0) {
                closestCommonLocation = closestCommonLocation + " " + countryCode;
            }
            return closestCommonLocation;
        }
        closestCommonLocation = this.valueIfEqual(addr1CountryCode, addr2CountryCode);
        if (closestCommonLocation != null && !"".equals(closestCommonLocation)) {
            return closestCommonLocation;
        }
        String addr1Country = addr1.getCountryName();
        String addr2Country = addr2.getCountryName();
        if (addr1Country == null) {
            addr1Country = addr1CountryCode;
        }
        if (addr2Country == null) {
            addr2Country = addr2CountryCode;
        }
        if (addr1Country == null || addr2Country == null) {
            return null;
        }
        closestCommonLocation = addr1Country.length() > 8 || addr2Country.length() > 8 ? addr1CountryCode + " - " + addr2CountryCode : addr1Country + " - " + addr2Country;
        return closestCommonLocation;
    }

    private String checkNull(String locality) {
        if (locality == null) {
            return "";
        }
        if (locality.equals("null")) {
            return "";
        }
        return locality;
    }

    private String getLocalityAdminForAddress(Address addr, boolean approxLocation) {
        if (addr == null) {
            return "";
        }
        String localityAdminStr = addr.getLocality();
        if (localityAdminStr != null && !"null".equals(localityAdminStr)) {
            String adminArea;
            if (approxLocation) {
                // empty if block
            }
            if ((adminArea = addr.getAdminArea()) != null && adminArea.length() > 0) {
                localityAdminStr = localityAdminStr + ", " + adminArea;
            }
            return localityAdminStr;
        }
        return null;
    }

    public Address lookupAddress(double latitude, double longitude, boolean useCache) {
        try {
            long locationKey = (long)(((latitude + 90.0) * 2.0 * 90.0 + (longitude + 180.0)) * 6378137.0);
            byte[] cachedLocation = null;
            if (useCache && this.mGeoCache != null) {
                cachedLocation = this.mGeoCache.lookup(locationKey);
            }
            Address address = null;
            NetworkInfo networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
            if (cachedLocation == null || cachedLocation.length == 0) {
                if (networkInfo == null || !networkInfo.isConnected()) {
                    return null;
                }
                List addresses = this.mGeocoder.getFromLocation(latitude, longitude, 1);
                if (!addresses.isEmpty()) {
                    address = (Address)addresses.get(0);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(bos);
                    Locale locale = address.getLocale();
                    ReverseGeocoder.writeUTF(dos, locale.getLanguage());
                    ReverseGeocoder.writeUTF(dos, locale.getCountry());
                    ReverseGeocoder.writeUTF(dos, locale.getVariant());
                    ReverseGeocoder.writeUTF(dos, address.getThoroughfare());
                    int numAddressLines = address.getMaxAddressLineIndex();
                    dos.writeInt(numAddressLines);
                    for (int i = 0; i < numAddressLines; ++i) {
                        ReverseGeocoder.writeUTF(dos, address.getAddressLine(i));
                    }
                    ReverseGeocoder.writeUTF(dos, address.getFeatureName());
                    ReverseGeocoder.writeUTF(dos, address.getLocality());
                    ReverseGeocoder.writeUTF(dos, address.getAdminArea());
                    ReverseGeocoder.writeUTF(dos, address.getSubAdminArea());
                    ReverseGeocoder.writeUTF(dos, address.getCountryName());
                    ReverseGeocoder.writeUTF(dos, address.getCountryCode());
                    ReverseGeocoder.writeUTF(dos, address.getPostalCode());
                    ReverseGeocoder.writeUTF(dos, address.getPhone());
                    ReverseGeocoder.writeUTF(dos, address.getUrl());
                    dos.flush();
                    if (this.mGeoCache != null) {
                        this.mGeoCache.insert(locationKey, bos.toByteArray());
                    }
                    dos.close();
                }
            } else {
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(cachedLocation));
                String language = ReverseGeocoder.readUTF(dis);
                String country = ReverseGeocoder.readUTF(dis);
                String variant = ReverseGeocoder.readUTF(dis);
                Locale locale = null;
                if (language != null) {
                    locale = country == null ? new Locale(language) : (variant == null ? new Locale(language, country) : new Locale(language, country, variant));
                }
                if (!locale.getLanguage().equals(Locale.getDefault().getLanguage())) {
                    dis.close();
                    return this.lookupAddress(latitude, longitude, false);
                }
                address = new Address(locale);
                address.setThoroughfare(ReverseGeocoder.readUTF(dis));
                int numAddressLines = dis.readInt();
                for (int i = 0; i < numAddressLines; ++i) {
                    address.setAddressLine(i, ReverseGeocoder.readUTF(dis));
                }
                address.setFeatureName(ReverseGeocoder.readUTF(dis));
                address.setLocality(ReverseGeocoder.readUTF(dis));
                address.setAdminArea(ReverseGeocoder.readUTF(dis));
                address.setSubAdminArea(ReverseGeocoder.readUTF(dis));
                address.setCountryName(ReverseGeocoder.readUTF(dis));
                address.setCountryCode(ReverseGeocoder.readUTF(dis));
                address.setPostalCode(ReverseGeocoder.readUTF(dis));
                address.setPhone(ReverseGeocoder.readUTF(dis));
                address.setUrl(ReverseGeocoder.readUTF(dis));
                dis.close();
            }
            return address;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String valueIfEqual(String a, String b) {
        return a != null && b != null && a.equalsIgnoreCase(b) ? a : null;
    }

    public static final void writeUTF(DataOutputStream dos, String string2) throws IOException {
        if (string2 == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(string2);
        }
    }

    public static final String readUTF(DataInputStream dis) throws IOException {
        String retVal = dis.readUTF();
        if (retVal.length() == 0) {
            return null;
        }
        return retVal;
    }

    public static class SetLatLong {
        public double mMinLatLatitude = 90.0;
        public double mMinLatLongitude;
        public double mMaxLatLatitude = -90.0;
        public double mMaxLatLongitude;
        public double mMinLonLatitude;
        public double mMinLonLongitude = 180.0;
        public double mMaxLonLatitude;
        public double mMaxLonLongitude = -180.0;
    }
}

