/*
 * Decompiled with CFR 0.152.
 */
package deviceinfo.mayur.medialibrary.util;

import android.util.Log;
import deviceinfo.mayur.medialibrary.util.Future;
import deviceinfo.mayur.medialibrary.util.FutureListener;
import deviceinfo.mayur.medialibrary.util.PriorityThreadFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPool {
    private static final String TAG = "ThreadPool";
    private static final int CORE_POOL_SIZE = 4;
    private static final int MAX_POOL_SIZE = 8;
    private static final int KEEP_ALIVE_TIME = 10;
    public static final int MODE_NONE = 0;
    public static final int MODE_CPU = 1;
    public static final int MODE_NETWORK = 2;
    public static final JobContext JOB_CONTEXT_STUB = new JobContextStub();
    ResourceCounter mCpuCounter = new ResourceCounter(2);
    ResourceCounter mNetworkCounter = new ResourceCounter(2);
    private final Executor mExecutor = new ThreadPoolExecutor(4, 8, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new PriorityThreadFactory("thread-pool", 10));

    public <T> Future<T> submit(Job<T> job, FutureListener<T> listener) {
        Worker<T> w = new Worker<T>(job, listener);
        this.mExecutor.execute(w);
        return w;
    }

    public <T> Future<T> submit(Job<T> job) {
        return this.submit(job, null);
    }

    private class Worker<T>
    implements Runnable,
    Future<T>,
    JobContext {
        private static final String TAG = "Worker";
        private Job<T> mJob;
        private FutureListener<T> mListener;
        private CancelListener mCancelListener;
        private ResourceCounter mWaitOnResource;
        private volatile boolean mIsCancelled;
        private boolean mIsDone;
        private T mResult;
        private int mMode;

        public Worker(Job<T> job, FutureListener<T> listener) {
            this.mJob = job;
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object result = null;
            if (this.setMode(1)) {
                try {
                    result = this.mJob.run(this);
                }
                catch (Throwable ex) {
                    Log.w((String)TAG, (String)"Exception in running a job", (Throwable)ex);
                }
            }
            Worker worker = this;
            synchronized (worker) {
                this.setMode(0);
                this.mResult = result;
                this.mIsDone = true;
                this.notifyAll();
            }
            if (this.mListener != null) {
                this.mListener.onFutureDone(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void cancel() {
            if (this.mIsCancelled) {
                return;
            }
            this.mIsCancelled = true;
            if (this.mWaitOnResource != null) {
                ResourceCounter resourceCounter = this.mWaitOnResource;
                synchronized (resourceCounter) {
                    this.mWaitOnResource.notifyAll();
                }
            }
            if (this.mCancelListener != null) {
                this.mCancelListener.onCancel();
            }
        }

        @Override
        public boolean isCancelled() {
            return this.mIsCancelled;
        }

        @Override
        public synchronized boolean isDone() {
            return this.mIsDone;
        }

        @Override
        public synchronized T get() {
            while (!this.mIsDone) {
                try {
                    this.wait();
                }
                catch (Exception ex) {
                    Log.w((String)TAG, (String)"ingore exception", (Throwable)ex);
                }
            }
            return this.mResult;
        }

        @Override
        public void waitDone() {
            this.get();
        }

        @Override
        public synchronized void setCancelListener(CancelListener listener) {
            this.mCancelListener = listener;
            if (this.mIsCancelled && this.mCancelListener != null) {
                this.mCancelListener.onCancel();
            }
        }

        @Override
        public boolean setMode(int mode) {
            ResourceCounter rc = this.modeToCounter(this.mMode);
            if (rc != null) {
                this.releaseResource(rc);
            }
            this.mMode = 0;
            rc = this.modeToCounter(mode);
            if (rc != null) {
                if (!this.acquireResource(rc)) {
                    return false;
                }
                this.mMode = mode;
            }
            return true;
        }

        private ResourceCounter modeToCounter(int mode) {
            if (mode == 1) {
                return ThreadPool.this.mCpuCounter;
            }
            if (mode == 2) {
                return ThreadPool.this.mNetworkCounter;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean acquireResource(ResourceCounter counter) {
            Object object;
            while (true) {
                object = this;
                synchronized (object) {
                    if (this.mIsCancelled) {
                        this.mWaitOnResource = null;
                        return false;
                    }
                    this.mWaitOnResource = counter;
                }
                object = counter;
                synchronized (object) {
                    if (counter.value > 0) {
                        --counter.value;
                        break;
                    }
                    try {
                        counter.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            object = this;
            synchronized (object) {
                this.mWaitOnResource = null;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseResource(ResourceCounter counter) {
            ResourceCounter resourceCounter = counter;
            synchronized (resourceCounter) {
                ++counter.value;
                counter.notifyAll();
            }
        }
    }

    private static class ResourceCounter {
        public int value;

        public ResourceCounter(int v) {
            this.value = v;
        }
    }

    public static interface CancelListener {
        public void onCancel();
    }

    private static class JobContextStub
    implements JobContext {
        private JobContextStub() {
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public void setCancelListener(CancelListener listener) {
        }

        @Override
        public boolean setMode(int mode) {
            return true;
        }
    }

    public static interface JobContext {
        public boolean isCancelled();

        public void setCancelListener(CancelListener var1);

        public boolean setMode(int var1);
    }

    public static interface Job<T> {
        public T run(JobContext var1);
    }
}

