/*
 * Decompiled with CFR 0.152.
 */
package com.github.mcheely.maven.requirejs;

import com.github.mcheely.maven.requirejs.MojoErrorReporter;
import com.github.mcheely.maven.requirejs.Optimizer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.mozilla.javascript.EvaluatorException;

public class OptimizeMojo
extends AbstractMojo {
    private MavenFileFilter mavenFileFilter;
    private MavenProject project;
    protected MavenSession session;
    private File optimizerFile;
    private File configFile;
    private boolean filterConfig;

    public void execute() throws MojoExecutionException {
        try {
            Optimizer builder = new Optimizer();
            MojoErrorReporter reporter = new MojoErrorReporter(this.getLog(), true);
            if (this.optimizerFile != null) {
                builder.optimize(this.createBuildProfile(), this.optimizerFile, reporter);
            } else {
                builder.optimize(this.createBuildProfile(), reporter);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read r.js", (Exception)e);
        }
        catch (EvaluatorException e) {
            throw new MojoExecutionException("Failed to execute r.js", (Exception)((Object)e));
        }
    }

    public Log getLog() {
        return super.getLog();
    }

    public Map getPluginContext() {
        return super.getPluginContext();
    }

    private File createBuildProfile() throws MojoExecutionException {
        if (this.filterConfig) {
            File filteredConfig;
            try {
                filteredConfig = File.createTempFile("requirejs-maven-plugin-profile", ".js");
                this.mavenFileFilter.copyFile(this.configFile, filteredConfig, true, this.project, new ArrayList(), true, "UTF8", this.session);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating temp copy of config.", (Exception)e);
            }
            catch (MavenFilteringException e) {
                throw new MojoExecutionException("Error filtering config file.", (Exception)((Object)e));
            }
            return filteredConfig;
        }
        return this.configFile;
    }
}

