/*
 * Decompiled with CFR 0.152.
 */
package com.github.mcheely.maven.requirejs;

import com.github.mcheely.maven.requirejs.RhinoRunner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.codehaus.plexus.util.IOUtil;
import org.mozilla.javascript.ErrorReporter;

public class Optimizer {
    private static final String CLASSPATH_R_JS = "/r.js";

    public void optimize(File buildProfile, ErrorReporter reporter) throws IOException {
        File optimizerFile = this.getClasspathOptimizerFile();
        this.optimize(buildProfile, optimizerFile, reporter);
    }

    public void optimize(File buildProfile, File optimizerFile, ErrorReporter reporter) throws IOException {
        String[] args = new String[]{"-o", buildProfile.getAbsolutePath()};
        RhinoRunner runner = new RhinoRunner();
        runner.exec(optimizerFile, args, reporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getClasspathOptimizerFile() throws IOException {
        File optimizerFile = File.createTempFile("build", "js");
        optimizerFile.deleteOnExit();
        FileOutputStream out = null;
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream(CLASSPATH_R_JS);
            out = new FileOutputStream(optimizerFile);
            IOUtil.copy((InputStream)in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((InputStream)in);
        IOUtil.close((OutputStream)out);
        return optimizerFile;
    }
}

