/*
 * Decompiled with CFR 0.152.
 */
package com.github.mcheely.maven.requirejs;

import com.github.mcheely.maven.requirejs.RhinoRunnerException;
import java.io.File;
import java.io.IOException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.SourceReader;
import org.mozilla.javascript.tools.shell.Global;
import org.mozilla.javascript.tools.shell.QuitAction;

public class RhinoRunner {
    private static final long serialVersionUID = 3859222870741981547L;
    private ContextFactory contextFactory = new ContextFactory();
    private Global global = new Global();
    private File file;

    public void exec(File mainScript, final String[] args, final ErrorReporter reporter) {
        if (!this.global.isInitialized()) {
            this.global.init(this.contextFactory);
            this.global.initQuitAction(new QuitAction(){

                public void quit(Context context, int exitCode) {
                    if (exitCode != 0) {
                        throw new RhinoRunnerException("Script exited with non-zero status: " + exitCode);
                    }
                }
            });
        }
        this.file = mainScript;
        this.contextFactory.call(new ContextAction(){

            public Object run(Context cx) {
                cx.setErrorReporter(reporter);
                RhinoRunner.this.processFile(cx, args);
                return null;
            }
        });
    }

    private void processFile(Context cx, String[] args) {
        Script script;
        Object[] array = new Object[args.length];
        System.arraycopy(args, 0, array, 0, args.length);
        Scriptable argsObj = cx.newArray((Scriptable)this.global, array);
        if (!this.global.has("arguments", (Scriptable)this.global)) {
            this.global.defineProperty("arguments", (Object)argsObj, 2);
        } else {
            this.global.put("arguments", (Scriptable)this.global, (Object)argsObj);
        }
        String path = this.file.getAbsolutePath();
        Object source = RhinoRunner.readFileOrUrl(path, true);
        String strSrc = (String)source;
        if (strSrc.length() > 0 && strSrc.charAt(0) == '#') {
            for (int i = 1; i != strSrc.length(); ++i) {
                char c = strSrc.charAt(i);
                if (c != '\n' && c != '\r') continue;
                strSrc = strSrc.substring(i);
                break;
            }
        }
        if ((script = cx.compileString(strSrc, path, 1, null)) != null) {
            script.exec(cx, (Scriptable)this.global);
        }
    }

    private static Object readFileOrUrl(String path, boolean convertToString) {
        try {
            return SourceReader.readFileOrUrl((String)path, (boolean)convertToString, null);
        }
        catch (IOException e) {
            throw new RhinoRunnerException("Unable to read script.", e);
        }
    }
}

