/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.bean.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.meanbean.bean.info.PropertyInformation;
import org.meanbean.test.Configuration;
import org.meanbean.util.ValidationHelper;

public final class PropertyInformationFilter {
    private PropertyInformationFilter() {
    }

    public static List<PropertyInformation> filter(Collection<PropertyInformation> properties, Predicate<PropertyInformation> filter) throws IllegalArgumentException {
        ValidationHelper.ensureExists("properties", "filter Collection of properties", properties);
        ValidationHelper.ensureExists("filter", "filter Collection of properties", filter);
        ArrayList<PropertyInformation> result = new ArrayList<PropertyInformation>();
        for (PropertyInformation propertyInformation : properties) {
            if (!filter.test(propertyInformation)) continue;
            result.add(propertyInformation);
        }
        return result;
    }

    public static List<PropertyInformation> filter(Collection<PropertyInformation> properties, Configuration configuration) {
        ValidationHelper.ensureExists("properties", "filter Collection of properties", properties);
        return properties.stream().filter(PropertyVisibility.READABLE_WRITABLE).filter(property -> configuration == null || !configuration.isIgnoredProperty(property.getName())).collect(Collectors.toList());
    }

    public static enum PropertyVisibility implements Predicate<PropertyInformation>
    {
        READABLE{

            @Override
            boolean isRelevant(PropertyInformation propertyInformation) {
                return propertyInformation != null ? propertyInformation.isReadable() : false;
            }
        }
        ,
        WRITABLE{

            @Override
            boolean isRelevant(PropertyInformation propertyInformation) {
                return propertyInformation != null ? propertyInformation.isWritable() : false;
            }
        }
        ,
        READABLE_WRITABLE{

            @Override
            boolean isRelevant(PropertyInformation propertyInformation) {
                return propertyInformation != null ? propertyInformation.isReadableWritable() : false;
            }
        };


        abstract boolean isRelevant(PropertyInformation var1);

        @Override
        public boolean test(PropertyInformation propertyInformation) {
            return this.isRelevant(propertyInformation);
        }
    }
}

