/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.factories;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.meanbean.factories.FactoryCollection;
import org.meanbean.factories.ObjectCreationException;
import org.meanbean.lang.Factory;
import org.meanbean.util.ValidationHelper;
import org.meanbean.util.reflect.ReflectionAccessor;

public class BasicNewObjectInstanceFactory
implements Factory<Object> {
    private final Class<?> clazz;

    public static Factory<Object> findBeanFactory(Class<?> clazz) {
        FactoryCollection factoryCollection = FactoryCollection.getInstance();
        if (factoryCollection.hasFactory(clazz)) {
            return factoryCollection.getFactory(clazz);
        }
        return new BasicNewObjectInstanceFactory(clazz);
    }

    public BasicNewObjectInstanceFactory(Class<?> clazz) throws IllegalArgumentException {
        ValidationHelper.ensureExists("clazz", "construct Factory", clazz);
        this.clazz = clazz;
    }

    @Override
    public Object create() throws ObjectCreationException {
        Object result = null;
        try {
            Constructor<?> declaredConstructor = this.clazz.getDeclaredConstructor(new Class[0]);
            ReflectionAccessor.getInstance().makeAccessible(declaredConstructor);
            result = declaredConstructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            this.wrapAndRethrowException(e);
        }
        catch (IllegalAccessException e) {
            this.wrapAndRethrowException(e);
        }
        catch (SecurityException e) {
            this.wrapAndRethrowException(e);
        }
        catch (NoSuchMethodException e) {
            this.wrapAndRethrowException(e);
        }
        catch (IllegalArgumentException e) {
            this.wrapAndRethrowException(e);
        }
        catch (InvocationTargetException e) {
            this.wrapAndRethrowException(e);
        }
        return result;
    }

    private void wrapAndRethrowException(Exception exception) throws ObjectCreationException {
        String message = "Failed to instantiate object of type [" + this.clazz.getName() + "] due to " + exception.getClass().getSimpleName() + ".";
        if (exception instanceof NoSuchMethodException) {
            message = message + " Do you need to add a custom Factory?";
        }
        throw new ObjectCreationException(message, exception);
    }
}

