/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.factories.basic;

import org.meanbean.factories.basic.RandomFactoryBase;
import org.meanbean.util.RandomValueGenerator;
import org.meanbean.util.ValidationHelper;

public class EnumFactory
extends RandomFactoryBase<Enum<?>> {
    private final Enum<?>[] enumConstants;

    public EnumFactory(Class<?> enumClass, RandomValueGenerator randomValueGenerator) throws IllegalArgumentException {
        super(randomValueGenerator);
        ValidationHelper.ensureExists("enumClass", "construct EnumFactory", enumClass);
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException("Cannot create EnumFactory for non-Enum class.");
        }
        this.enumConstants = (Enum[])enumClass.getEnumConstants();
    }

    @Override
    public Enum<?> create() {
        double random = this.getRandomValueGenerator().nextDouble();
        int ordinal = (int)((double)(this.enumConstants.length - 1) * random);
        return this.enumConstants[ordinal];
    }
}

