/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.test;

import java.util.List;
import java.util.function.Function;
import org.meanbean.bean.info.BeanInformation;
import org.meanbean.bean.info.BeanInformationFactory;
import org.meanbean.bean.info.PropertyInformation;
import org.meanbean.bean.util.PropertyInformationFilter;
import org.meanbean.factories.BasicNewObjectInstanceFactory;
import org.meanbean.factories.FactoryCollection;
import org.meanbean.factories.util.FactoryLookupStrategy;
import org.meanbean.lang.Factory;
import org.meanbean.test.BeanPropertyTester;
import org.meanbean.test.BeanTestException;
import org.meanbean.test.Configuration;
import org.meanbean.test.Warning;
import org.meanbean.test.internal.EqualityTest;
import org.meanbean.test.internal.NoopSideEffectDetector;
import org.meanbean.test.internal.SideEffectDetector;
import org.meanbean.util.RandomValueGenerator;
import org.meanbean.util.ServiceFactory;
import org.meanbean.util.ServiceLoader;
import org.meanbean.util.ValidationHelper;

public class BeanTester {
    public static final int TEST_ITERATIONS_PER_BEAN = 100;
    private final RandomValueGenerator randomValueGenerator;
    private final FactoryCollection factoryCollection;
    private final FactoryLookupStrategy factoryLookupStrategy;
    private final Function<Class<?>, Configuration> configurationProvider;
    private final BeanInformationFactory beanInformationFactory;
    private final BeanPropertyTester beanPropertyTester;

    public BeanTester() {
        ServiceFactory.createContext(this);
        this.randomValueGenerator = RandomValueGenerator.getInstance();
        this.factoryCollection = FactoryCollection.getInstance();
        this.factoryLookupStrategy = FactoryLookupStrategy.getInstance();
        this.beanInformationFactory = BeanInformationFactory.getInstance();
        this.beanPropertyTester = new BeanPropertyTester();
        this.configurationProvider = Configuration.defaultConfigurationProvider();
    }

    BeanTester(RandomValueGenerator randomValueGenerator, FactoryCollection factoryCollection, FactoryLookupStrategy factoryLookupStrategy, BeanInformationFactory beanInformationFactory, BeanPropertyTester beanPropertyTester, Function<Class<?>, Configuration> configurationProvider) {
        ServiceFactory.createContextIfNeeded(this);
        this.randomValueGenerator = randomValueGenerator;
        this.factoryCollection = factoryCollection;
        this.factoryLookupStrategy = factoryLookupStrategy;
        this.beanInformationFactory = beanInformationFactory;
        this.beanPropertyTester = beanPropertyTester;
        this.configurationProvider = configurationProvider;
    }

    public FactoryCollection getFactoryCollection() {
        return this.factoryCollection;
    }

    public RandomValueGenerator getRandomValueGenerator() {
        return this.randomValueGenerator;
    }

    public int getIterations() {
        Class<?> anonymousClass = new Object(){}.getClass();
        return this.configurationProvider.apply(anonymousClass).getIterations();
    }

    public void testBean(Class<?> beanClass) throws IllegalArgumentException, AssertionError, BeanTestException {
        ValidationHelper.ensureExists("beanClass", "test bean", beanClass);
        Configuration customConfiguration = this.configurationProvider.apply(beanClass);
        this.testBean(beanClass, customConfiguration);
    }

    public void testBeans(Class<?> ... beanClasses) throws IllegalArgumentException, AssertionError, BeanTestException {
        for (Class<?> beanClass : beanClasses) {
            this.testBean(beanClass);
        }
    }

    public void testBean(Class<?> beanClass, Configuration customConfiguration) throws IllegalArgumentException, AssertionError, BeanTestException {
        ValidationHelper.ensureExists("beanClass", "test bean", beanClass);
        int iterations = this.getIterations();
        if (customConfiguration != null && customConfiguration.hasIterationsOverride()) {
            iterations = customConfiguration.getIterations();
        }
        if (iterations < 1) {
            throw new IllegalArgumentException("Iterations must be at least 1.");
        }
        BeanInformation beanInformation = this.beanInformationFactory.create(beanClass);
        for (int idx = 0; idx < iterations; ++idx) {
            this.testBean(beanInformation, customConfiguration);
        }
    }

    protected void testBean(BeanInformation beanInformation, Configuration configuration) throws IllegalArgumentException, AssertionError, BeanTestException {
        Object bean;
        ValidationHelper.ensureExists("beanInformation", "test bean", beanInformation);
        List<PropertyInformation> readableWritableProperties = PropertyInformationFilter.filter(beanInformation.getProperties(), configuration);
        Factory<Object> beanFactory = BasicNewObjectInstanceFactory.findBeanFactory(beanInformation.getBeanClass());
        try {
            bean = beanFactory.create();
        }
        catch (Exception e) {
            String message = "Cannot test bean [" + beanInformation.getBeanClass().getName() + "]. Failed to instantiate an instance of the bean.";
            throw new BeanTestException(message, e);
        }
        SideEffectDetector sideEffectDetector = this.createSideEffectDetector(configuration);
        sideEffectDetector.init(bean, readableWritableProperties);
        for (PropertyInformation property : readableWritableProperties) {
            EqualityTest equalityTest = EqualityTest.LOGICAL;
            Object testValue = null;
            try {
                Factory<?> valueFactory = this.factoryLookupStrategy.getFactory(beanInformation, property, configuration);
                testValue = valueFactory.create();
                if (valueFactory instanceof BasicNewObjectInstanceFactory) {
                    equalityTest = EqualityTest.ABSOLUTE;
                }
            }
            catch (Exception e) {
                String message = "Cannot test bean [" + beanInformation.getBeanClass().getName() + "]. Failed to instantiate a test value for property [" + property.getName() + "].";
                throw new BeanTestException(message, e);
            }
            sideEffectDetector.beforeTestProperty(property, equalityTest);
            this.beanPropertyTester.testProperty(bean, property, testValue, equalityTest);
            sideEffectDetector.detectAfterTestProperty();
        }
    }

    private SideEffectDetector createSideEffectDetector(Configuration configuration) {
        if (configuration != null && configuration.isSuppressedWarning(Warning.SETTER_SIDE_EFFECT)) {
            return NoopSideEffectDetector.INSTANCE;
        }
        ServiceLoader<SideEffectDetector> serviceLoader = new ServiceLoader<SideEffectDetector>(SideEffectDetector.class, new Class[0]);
        return serviceLoader.createAll(new Object[0]).get(0);
    }
}

