/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.test;

import com.github.meanbeanlib.mirror.SerializableLambdas;
import java.util.function.Consumer;
import org.meanbean.bean.info.BeanInformationFactory;
import org.meanbean.factories.FactoryCollection;
import org.meanbean.factories.util.FactoryLookupStrategy;
import org.meanbean.lang.Factory;
import org.meanbean.test.BeanTesterBuilder;
import org.meanbean.test.BeanVerifier;
import org.meanbean.test.VerifierSettings;
import org.meanbean.test.VerifierSettingsEditor;
import org.meanbean.test.Warning;
import org.meanbean.util.RandomValueGenerator;
import org.meanbean.util.ServiceFactory;

class BeanVerifierImpl
implements BeanVerifier,
VerifierSettings,
VerifierSettingsEditor {
    private Class<?> beanClass;
    private final BeanTesterBuilder builder;

    public BeanVerifierImpl(Class<?> beanClass) {
        ServiceFactory.createContext(this);
        this.beanClass = beanClass;
        this.builder = BeanTesterBuilder.newBeanTesterBuilderWithInheritedContext();
    }

    @Override
    public BeanVerifier withSettings(Consumer<VerifierSettings> verifierSettingsEditor) {
        verifierSettingsEditor.accept(this);
        return this;
    }

    @Override
    public VerifierSettingsEditor editSettings() {
        return this;
    }

    @Override
    public BeanVerifier edited() {
        return this;
    }

    @Override
    public BeanVerifier verifyGettersAndSetters() {
        this.builder.build().testBean(this.beanClass);
        return this;
    }

    @Override
    public BeanVerifier verifyEqualsAndHashCode() {
        this.builder.buildEqualsMethodTester().testEqualsMethod(this.beanClass, new String[0]);
        this.builder.buildHashCodeMethodTester().testHashCodeMethod(this.beanClass);
        return this;
    }

    @Override
    public BeanVerifier verifyToString() {
        this.builder.buildToStringMethodTester().testToStringMethod(this.beanClass);
        return this;
    }

    @Override
    public VerifierSettingsEditor suppressWarning(Warning warning) {
        this.builder.getConfigurationFor(this.beanClass).suppress(warning);
        return this;
    }

    @Override
    public RandomValueGenerator getRandomValueGenerator() {
        return this.builder.getRandomValueGenerator();
    }

    @Override
    public VerifierSettingsEditor setRandomValueGenerator(RandomValueGenerator randomValueGenerator) {
        this.builder.setRandomValueGenerator(randomValueGenerator);
        return this;
    }

    @Override
    public FactoryCollection getFactoryCollection() {
        return this.builder.getFactoryCollection();
    }

    @Override
    public VerifierSettingsEditor setFactoryCollection(FactoryCollection factoryCollection) {
        this.builder.setFactoryCollection(factoryCollection);
        return this;
    }

    @Override
    public FactoryLookupStrategy getFactoryLookupStrategy() {
        return this.builder.getFactoryLookupStrategy();
    }

    @Override
    public VerifierSettingsEditor setFactoryLookupStrategy(FactoryLookupStrategy factoryLookupStrategy) {
        this.builder.setFactoryLookupStrategy(factoryLookupStrategy);
        return this;
    }

    @Override
    public BeanInformationFactory getBeanInformationFactory() {
        return this.builder.getBeanInformationFactory();
    }

    @Override
    public VerifierSettingsEditor setBeanInformationFactory(BeanInformationFactory beanInformationFactory) {
        this.builder.setBeanInformationFactory(beanInformationFactory);
        return this;
    }

    @Override
    public <T> VerifierSettingsEditor registerFactory(Class<T> clazz, Factory<? extends T> factory) {
        this.builder.registerFactory(clazz, factory);
        return this;
    }

    @Override
    public <T> VerifierSettingsEditor registerTypeHierarchyFactory(Class<T> baseType, Factory<T> factory) {
        this.builder.registerTypeHierarchyFactory(baseType, factory);
        return this;
    }

    @Override
    public int getDefaultIterations() {
        return this.builder.getDefaultIterations();
    }

    @Override
    public VerifierSettingsEditor setDefaultIterations(int iterations) {
        this.builder.setDefaultIterations(iterations);
        return this;
    }

    @Override
    public VerifierSettingsEditor addIgnoredPropertyName(String property) {
        this.builder.addIgnoredPropertyName(this.beanClass(), property);
        return this;
    }

    @Override
    public <T, S> VerifierSettingsEditor addIgnoredProperty(SerializableLambdas.SerializableFunction1<T, S> beanGetter) {
        this.builder.addIgnoredProperty(this.beanClass(), beanGetter);
        return this;
    }

    @Override
    public <T> VerifierSettingsEditor addOverrideFactory(String property, Factory<T> factory) {
        this.builder.addOverrideFactory(this.beanClass(), property, factory);
        return this;
    }

    @Override
    public <T, S> VerifierSettingsEditor addOverridePropertyFactory(SerializableLambdas.SerializableFunction1<T, S> beanGetter, Factory<S> factory) {
        this.builder.addOverridePropertyFactory(this.beanClass(), beanGetter, factory);
        return this;
    }

    @Override
    public <T, S> VerifierSettingsEditor addEqualsInsignificantProperty(String propertyName) {
        this.builder.addEqualsInsignificantProperty(this.beanClass(), propertyName);
        return this;
    }

    @Override
    public <T, S> VerifierSettingsEditor addEqualsInsignificantProperty(SerializableLambdas.SerializableFunction1<T, S> beanGetter) {
        this.builder.addEqualsInsignificantProperty(this.beanClass(), beanGetter);
        return this;
    }

    private <T> Class<T> beanClass() {
        return this.beanClass;
    }
}

