/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.test;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.meanbean.lang.Factory;
import org.meanbean.test.Configuration;
import org.meanbean.test.Warning;
import org.meanbean.util.ValidationHelper;

public class ConfigurationBuilder {
    private Integer iterations;
    private final Set<String> ignoredProperties = ConcurrentHashMap.newKeySet();
    private final Map<String, Factory<?>> overrideFactories = new ConcurrentHashMap();
    private Set<Warning> suppressedWarnings = EnumSet.noneOf(Warning.class);

    public ConfigurationBuilder iterations(int iterations) {
        if (iterations < 1) {
            throw new IllegalArgumentException("Iterations must be at least 1.");
        }
        this.iterations = iterations;
        return this;
    }

    public ConfigurationBuilder ignoreProperty(String property) throws IllegalArgumentException {
        ValidationHelper.ensureExists("property", "add property to ignored properties collection", property);
        this.ignoredProperties.add(property);
        return this;
    }

    public ConfigurationBuilder overrideFactory(String property, Factory<?> factory) throws IllegalArgumentException {
        ValidationHelper.ensureExists("property", "add override Factory", property);
        ValidationHelper.ensureExists("factory", "add override Factory", factory);
        this.overrideFactories.put(property, factory);
        return this;
    }

    public Configuration build() {
        return new Configuration(this.iterations, Collections.unmodifiableSet(this.ignoredProperties), Collections.unmodifiableMap(this.overrideFactories), Collections.unmodifiableSet(this.suppressedWarnings));
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("ConfigurationBuilder[");
        str.append("iterations=").append(this.iterations).append(",");
        str.append("ignoredProperties=").append(new TreeSet<String>(this.ignoredProperties)).append(",");
        str.append("overrideFactories=").append(new TreeMap(this.overrideFactories));
        str.append("]");
        return str.toString();
    }
}

