/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.test;

import java.util.function.Function;
import org.meanbean.bean.info.BeanInformationException;
import org.meanbean.bean.info.BeanInformationFactory;
import org.meanbean.factories.equivalent.EquivalentEnumFactory;
import org.meanbean.factories.equivalent.EquivalentPopulatedBeanFactory;
import org.meanbean.factories.util.FactoryLookupStrategy;
import org.meanbean.lang.EquivalentFactory;
import org.meanbean.test.BeanTestException;
import org.meanbean.test.Configuration;
import org.meanbean.test.EqualsMethodContractVerifier;
import org.meanbean.test.EqualsMethodPropertySignificanceVerifier;
import org.meanbean.test.PropertyBasedEqualsMethodPropertySignificanceVerifier;
import org.meanbean.util.ServiceFactory;
import org.meanbean.util.ValidationHelper;

public class EqualsMethodTester {
    private final BeanInformationFactory beanInformationFactory;
    private final EqualsMethodContractVerifier contractVerifier;
    private final EqualsMethodPropertySignificanceVerifier propertySignificanceVerifier;
    private final Function<Class<?>, Configuration> configurationProvider;

    public EqualsMethodTester() {
        ServiceFactory.createContext(this);
        this.configurationProvider = Configuration.defaultConfigurationProvider();
        this.propertySignificanceVerifier = new PropertyBasedEqualsMethodPropertySignificanceVerifier();
        this.contractVerifier = new EqualsMethodContractVerifier();
        this.beanInformationFactory = BeanInformationFactory.getInstance();
    }

    static EqualsMethodTester createWithInheritedContext(Function<Class<?>, Configuration> configurationProvider) {
        return new EqualsMethodTester(configurationProvider);
    }

    private EqualsMethodTester(Function<Class<?>, Configuration> configurationProvider) {
        ValidationHelper.ensure(ServiceFactory.hasContext(), "context required");
        this.configurationProvider = configurationProvider;
        this.propertySignificanceVerifier = new PropertyBasedEqualsMethodPropertySignificanceVerifier();
        this.beanInformationFactory = BeanInformationFactory.getInstance();
        this.contractVerifier = new EqualsMethodContractVerifier();
    }

    public void testEqualsMethod(Class<?> clazz, String ... insignificantProperties) throws IllegalArgumentException, BeanInformationException, BeanTestException, AssertionError {
        this.testEqualsMethod(clazz, (Configuration)null, insignificantProperties);
    }

    public void testEqualsMethod(Class<?> clazz, Configuration customConfiguration, String ... insignificantProperties) throws IllegalArgumentException, BeanInformationException, BeanTestException, AssertionError {
        ValidationHelper.ensureExists("clazz", "test equals method", clazz);
        EquivalentFactory<?> factory = this.createEquivalentFactory(clazz);
        customConfiguration = this.getEffectiveConfiguration(clazz, customConfiguration);
        this.testEqualsMethod(factory, customConfiguration, insignificantProperties);
    }

    public void testEqualsMethod(EquivalentFactory<?> factory, String ... insignificantProperties) throws IllegalArgumentException, BeanInformationException, BeanTestException, AssertionError {
        this.testEqualsMethod(factory, (Configuration)null, insignificantProperties);
    }

    public void testEqualsMethod(EquivalentFactory<?> factory, Configuration customConfiguration, String ... insignificantProperties) throws IllegalArgumentException, BeanInformationException, BeanTestException, AssertionError {
        ValidationHelper.ensureExists("factory", "test equals method", factory);
        ValidationHelper.ensureExists("insignificantProperties", "test equals method", insignificantProperties);
        insignificantProperties = insignificantProperties == null || insignificantProperties.length == 0 ? this.defaultConfiguration().getEqualsInsignificantProperties().toArray(new String[0]) : insignificantProperties;
        this.contractVerifier.verifyEqualsReflexive(factory);
        this.contractVerifier.verifyEqualsSymmetric(factory);
        this.contractVerifier.verifyEqualsTransitive(factory);
        this.contractVerifier.verifyEqualsConsistent(factory);
        this.contractVerifier.verifyEqualsNull(factory);
        this.contractVerifier.verifyEqualsDifferentType(factory);
        customConfiguration = this.getEffectiveConfiguration(null, customConfiguration);
        int iterations = this.defaultConfiguration().getIterations();
        if (customConfiguration.hasIterationsOverride()) {
            iterations = customConfiguration.getIterations();
        }
        for (int idx = 0; idx < iterations; ++idx) {
            this.propertySignificanceVerifier.verifyEqualsMethod(factory, customConfiguration, insignificantProperties);
        }
    }

    private Configuration defaultConfiguration() {
        Class<?> anonymousClass = new Object(){}.getClass();
        return this.configurationProvider.apply(anonymousClass);
    }

    private Configuration getEffectiveConfiguration(Class<?> beanClass, Configuration configuration) {
        if (beanClass == null) {
            beanClass = new Object(){}.getClass();
        }
        if (configuration != null) {
            return configuration;
        }
        return this.configurationProvider.apply(beanClass);
    }

    private EquivalentFactory<?> createEquivalentFactory(Class<?> clazz) {
        if (this.classIsAnEnum(clazz)) {
            return this.createEnumClassFactory(clazz);
        }
        return this.createPopulatedBeanFactory(clazz);
    }

    private boolean classIsAnEnum(Class<?> clazz) {
        return clazz.isEnum();
    }

    private EquivalentEnumFactory createEnumClassFactory(Class<?> clazz) {
        return new EquivalentEnumFactory(clazz);
    }

    private EquivalentPopulatedBeanFactory createPopulatedBeanFactory(Class<?> clazz) {
        FactoryLookupStrategy factoryLookupStrategy = FactoryLookupStrategy.getInstance();
        Configuration configuration = this.getEffectiveConfiguration(clazz, null);
        return new EquivalentPopulatedBeanFactory(this.beanInformationFactory.create(clazz), factoryLookupStrategy, configuration);
    }
}

