/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.meanbean.bean.info.BeanInformation;
import org.meanbean.bean.info.BeanInformationException;
import org.meanbean.bean.info.BeanInformationFactory;
import org.meanbean.bean.info.PropertyInformation;
import org.meanbean.bean.util.PropertyInformationFilter;
import org.meanbean.factories.util.FactoryLookupStrategy;
import org.meanbean.lang.EquivalentFactory;
import org.meanbean.lang.Factory;
import org.meanbean.test.BeanTestException;
import org.meanbean.test.Configuration;
import org.meanbean.test.EqualsMethodPropertySignificanceVerifier;
import org.meanbean.test.InsignificantObjectPropertyEqualityConsistentAsserter;
import org.meanbean.test.ObjectPropertyEqualityConsistentAsserter;
import org.meanbean.test.SignificantObjectPropertyEqualityConsistentAsserter;
import org.meanbean.util.ValidationHelper;

class PropertyBasedEqualsMethodPropertySignificanceVerifier
implements EqualsMethodPropertySignificanceVerifier {
    private final BeanInformationFactory beanInformationFactory = BeanInformationFactory.getInstance();
    private final FactoryLookupStrategy factoryLookupStrategy = FactoryLookupStrategy.getInstance();
    private final ObjectPropertyEqualityConsistentAsserter significantAsserter = new SignificantObjectPropertyEqualityConsistentAsserter();
    private final ObjectPropertyEqualityConsistentAsserter insignificantAsserter = new InsignificantObjectPropertyEqualityConsistentAsserter();

    PropertyBasedEqualsMethodPropertySignificanceVerifier() {
    }

    @Override
    public void verifyEqualsMethod(EquivalentFactory<?> factory, String ... insignificantProperties) throws IllegalArgumentException, BeanInformationException, BeanTestException, AssertionError {
        this.verifyEqualsMethod(factory, (Configuration)null, insignificantProperties);
    }

    @Override
    public void verifyEqualsMethod(EquivalentFactory<?> factory, Configuration customConfiguration, String ... insignificantProperties) throws IllegalArgumentException, BeanInformationException, BeanTestException, AssertionError {
        ValidationHelper.ensureExists("factory", "test equals", factory);
        ValidationHelper.ensureExists("insignificantProperties", "test equals", insignificantProperties);
        ArrayList<String> insignificantPropertyNames = new ArrayList<String>();
        insignificantPropertyNames.addAll(Arrays.asList(insignificantProperties));
        if (customConfiguration != null) {
            insignificantPropertyNames.addAll(customConfiguration.getEqualsInsignificantProperties());
        }
        Object prototype = factory.create();
        ValidationHelper.ensureExists("factory-created object", "test equals", prototype);
        BeanInformation beanInformation = this.beanInformationFactory.create(prototype.getClass());
        this.ensureInsignificantPropertiesExist(beanInformation, insignificantPropertyNames);
        Collection<PropertyInformation> properties = beanInformation.getProperties();
        properties = PropertyInformationFilter.filter(beanInformation.getProperties(), customConfiguration);
        for (PropertyInformation property : properties) {
            this.verifyEqualsMethodForProperty(beanInformation, factory, customConfiguration, property, !insignificantPropertyNames.contains(property.getName()));
        }
    }

    protected void ensureInsignificantPropertiesExist(BeanInformation beanInformation, List<String> insignificantProperties) throws IllegalArgumentException {
        ArrayList<String> unrecognisedPropertyNames = new ArrayList<String>(insignificantProperties);
        unrecognisedPropertyNames.removeAll(beanInformation.getPropertyNames());
        if (!unrecognisedPropertyNames.isEmpty()) {
            String message = "Insignificant properties [" + String.join((CharSequence)",", unrecognisedPropertyNames) + "] do not exist on " + beanInformation.getBeanClass().getName() + ".";
            throw new IllegalArgumentException(message);
        }
    }

    protected void verifyEqualsMethodForProperty(BeanInformation beanInformation, EquivalentFactory<?> factory, Configuration configuration, PropertyInformation property, boolean significant) throws IllegalArgumentException, BeanInformationException, BeanTestException, AssertionError {
        Object modifiedObj;
        String propertyName = property.getName();
        Object originalObj = factory.create();
        if (!originalObj.equals(modifiedObj = factory.create())) {
            String message = "Cannot test equals if factory does not create logically equivalent objects.";
            throw new IllegalArgumentException(message);
        }
        try {
            Object xOriginalValue = property.getReadMethod().invoke(originalObj, new Object[0]);
            Object originalVal = property.getReadMethod().invoke(modifiedObj, new Object[0]);
            ValidationHelper.ensureExists("factory-created object." + propertyName, "test equals", xOriginalValue);
            ValidationHelper.ensureExists("factory-created object." + propertyName, "test equals", originalVal);
            if (!originalVal.equals(xOriginalValue)) {
                String message = "Cannot test equals if factory does not create objects with same property values.";
                throw new IllegalArgumentException(message);
            }
            Factory<?> propertyFactory = this.factoryLookupStrategy.getFactory(beanInformation, property, configuration);
            Object newVal = propertyFactory.create();
            property.getWriteMethod().invoke(modifiedObj, newVal);
            if (significant) {
                this.significantAsserter.assertConsistent(propertyName, originalObj, modifiedObj, originalVal, newVal);
            } else {
                this.insignificantAsserter.assertConsistent(propertyName, originalObj, modifiedObj, originalVal, newVal);
            }
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e;
            }
            String message = "Failed to test property [" + property.getName() + "] due to Exception [" + e.getClass().getName() + "]: [" + e.getMessage() + "].";
            throw new BeanTestException(message, e);
        }
    }
}

