/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.test;

import java.util.Arrays;
import java.util.function.Supplier;
import org.meanbean.test.ObjectPropertyEqualityConsistentAsserter;
import org.meanbean.test.internal.$EqualsBuilder;
import org.meanbean.util.AssertionUtils;
import org.meanbean.util.ValidationHelper;

class SignificantObjectPropertyEqualityConsistentAsserter
implements ObjectPropertyEqualityConsistentAsserter {
    SignificantObjectPropertyEqualityConsistentAsserter() {
    }

    @Override
    public void assertConsistent(String propertyName, Object originalObject, Object modifiedObject, Object originalPropertyValue, Object newPropertyValue) throws IllegalArgumentException, AssertionError {
        ValidationHelper.ensureExists("propertyName", "assert consistency of equals", propertyName);
        ValidationHelper.ensureExists("originalObject", "assert consistency of equals", originalObject);
        ValidationHelper.ensureExists("modifiedObject", "assert consistency of equals", modifiedObject);
        ValidationHelper.ensureExists("originalPropertyValue", "assert consistency of equals", originalPropertyValue);
        ValidationHelper.ensureExists("newPropertyValue", "assert consistency of equals", newPropertyValue);
        boolean newPropertyValueEqualsOriginalPropertyValue = $EqualsBuilder.objectsEqual(newPropertyValue, originalPropertyValue);
        boolean originalObjectEqualsModifiedObject = $EqualsBuilder.objectsEqual(originalObject, modifiedObject);
        Supplier<String> variableString = SignificantObjectPropertyEqualityConsistentAsserter.formatVariableString(propertyName, originalPropertyValue, newPropertyValue);
        if (originalObjectEqualsModifiedObject && !newPropertyValueEqualsOriginalPropertyValue) {
            String message = "objects that differ due to supposedly significant property [" + propertyName + "] were considered equal. " + variableString.get() + ". is property [" + propertyName + "] actually insignificant?";
            AssertionUtils.fail(message);
        } else if (!originalObjectEqualsModifiedObject && newPropertyValueEqualsOriginalPropertyValue) {
            String message = "objects that should be equal were considered unequal when testing significant property [" + propertyName + "]. " + variableString.get() + ". is equals incorrect?";
            AssertionUtils.fail(message);
        }
    }

    static Supplier<String> formatVariableString(String propertyName, Object originalPropertyValue, Object newPropertyValue) {
        return () -> {
            String originalPropertyString = SignificantObjectPropertyEqualityConsistentAsserter.buildToString(originalPropertyValue);
            String newPropertyString = SignificantObjectPropertyEqualityConsistentAsserter.buildToString(newPropertyValue);
            return "(\nx." + propertyName + "=[" + originalPropertyString + "]\nvs\ny." + propertyName + "=[" + newPropertyString + "]\n)";
        };
    }

    private static String buildToString(Object obj) {
        if (obj != null && obj.getClass().isArray()) {
            Object[] objectArray = new Object[]{obj};
            String str = Arrays.deepToString(objectArray);
            return str.substring(1, str.length() - 1);
        }
        return String.valueOf(obj);
    }
}

