/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.test;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.meanbean.bean.info.BeanInformation;
import org.meanbean.bean.info.BeanInformationFactory;
import org.meanbean.factories.equivalent.EquivalentPopulatedBeanFactory;
import org.meanbean.factories.util.FactoryLookupStrategy;
import org.meanbean.test.Configuration;
import org.meanbean.util.ServiceFactory;
import org.meanbean.util.ValidationHelper;

public class ToStringMethodTester {
    private final Function<Class<?>, Configuration> configurationProvider;

    static ToStringMethodTester createWithInheritedContext(Function<Class<?>, Configuration> configurationProvider) {
        return new ToStringMethodTester(ServiceFactory::createContextIfNeeded, configurationProvider);
    }

    ToStringMethodTester(Function<Class<?>, Configuration> configurationProvider) {
        this(ServiceFactory::createContext, configurationProvider);
    }

    private ToStringMethodTester(Consumer<ToStringMethodTester> serviceCreator, Function<Class<?>, Configuration> configurationProvider) {
        serviceCreator.accept(this);
        this.configurationProvider = configurationProvider;
    }

    public void testToStringMethod(Class<?> beanClass) {
        ValidationHelper.ensureExists("clazz", "test toString method", beanClass);
        FactoryLookupStrategy factoryLookupStrategy = FactoryLookupStrategy.getInstance();
        BeanInformationFactory beanInformationFactory = BeanInformationFactory.getInstance();
        BeanInformation beanInformation = beanInformationFactory.create(beanClass);
        Configuration configuration = this.configurationProvider.apply(beanClass);
        EquivalentPopulatedBeanFactory factory = new EquivalentPopulatedBeanFactory(beanInformation, factoryLookupStrategy, configuration);
        Object bean = factory.create();
        String toString = bean.toString();
        if (!this.overridesToString(bean, toString)) {
            throw new AssertionError((Object)("Expected " + beanClass.getName() + " class to override toString()"));
        }
    }

    private boolean overridesToString(Object obj, String toString) {
        String defaultToString = obj.getClass().getName() + "@" + Integer.toHexString(obj.hashCode());
        return !Objects.equals(defaultToString, toString);
    }
}

