/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.util;

import java.util.Arrays;
import org.meanbean.util.ServiceFactory;

public class ServiceDefinition<T> {
    private Class<T> serviceType;
    private Class<?>[] constructorTypes = new Class[0];
    private Object[] constructorArgs = new Object[0];

    public ServiceDefinition(Class<T> serviceType) {
        this(serviceType, new Class[0], new Object[0]);
    }

    public ServiceDefinition(Class<T> serviceType, Class<?>[] constructorTypes, Object[] constructorArgs) {
        if (constructorTypes.length != constructorArgs.length) {
            throw new IllegalArgumentException();
        }
        this.serviceType = serviceType;
        this.constructorTypes = Arrays.copyOf(constructorTypes, constructorTypes.length);
        this.constructorArgs = Arrays.copyOf(constructorArgs, constructorTypes.length);
    }

    Class<T> getServiceType() {
        return this.serviceType;
    }

    Class<?>[] getConstructorTypes() {
        return this.constructorTypes;
    }

    Object[] getConstructorArgs() {
        return this.constructorArgs;
    }

    public ServiceFactory<T> getServiceFactory() {
        return ServiceFactory.getInstance(this);
    }
}

