/*
 * Decompiled with CFR 0.152.
 */
package com.github.meanbeanlib.mirror;

import com.github.meanbeanlib.mirror.ClassUtils;
import com.github.meanbeanlib.mirror.SerializableLambdas;
import com.github.meanbeanlib.mirror.Utility;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;

public class Executables {
    public static Executable findExecutable(SerializableLambdas.SerializableLambda consumer) {
        return Executables.doFindMethod(consumer);
    }

    public static Method findMethod(SerializableLambdas.SerializableConsumer0 consumer) {
        return (Method)Executables.doFindMethod(consumer);
    }

    public static <T> Method findGetter(SerializableLambdas.SerializableFunction0<T> fn) {
        return (Method)Executables.doFindMethod(fn);
    }

    public static <T1> Method findMethod(SerializableLambdas.SerializableConsumer1<T1> consumer) {
        return (Method)Executables.doFindMethod(consumer);
    }

    public static <T1, R> Method findGetter(SerializableLambdas.SerializableFunction1<T1, R> fn) {
        return (Method)Executables.doFindMethod(fn);
    }

    public static <T1, T2> Method findMethod(SerializableLambdas.SerializableConsumer2<T1, T2> consumer) {
        return (Method)Executables.doFindMethod(consumer);
    }

    public static <T1, T2, R> Method findGetter(SerializableLambdas.SerializableFunction2<T1, T2, R> fn) {
        return (Method)Executables.doFindMethod(fn);
    }

    public static <T1, T2, T3> Method findMethod(SerializableLambdas.SerializableConsumer3<T1, T2, T3> consumer) {
        return (Method)Executables.doFindMethod(consumer);
    }

    public static <T1, T2, T3, R> Method findGetter(SerializableLambdas.SerializableFunction3<T1, T2, T3, R> fn) {
        return (Method)Executables.doFindMethod(fn);
    }

    public static <T1, T2, T3, T4> Method findMethod(SerializableLambdas.SerializableConsumer4<T1, T2, T3, T4> consumer) {
        return (Method)Executables.doFindMethod(consumer);
    }

    public static <T1, T2, T3, T4, R> Method findGetter(SerializableLambdas.SerializableFunction4<T1, T2, T3, T4, R> fn) {
        return (Method)Executables.doFindMethod(fn);
    }

    public static <R> Constructor<R> findConstructor(SerializableLambdas.SerializableFunction0<R> fn) {
        return (Constructor)Executables.doFindMethod(fn);
    }

    public static <R> Constructor<R> findConstructor0(SerializableLambdas.SerializableFunction0<R> fn) {
        return (Constructor)Executables.doFindMethod(fn);
    }

    public static <T1, R> Constructor<R> findConstructor1(SerializableLambdas.SerializableFunction1<T1, R> fn) {
        return (Constructor)Executables.doFindMethod(fn);
    }

    public static <T1, T2, R> Constructor<R> findConstructor(SerializableLambdas.SerializableFunction2<T1, T2, R> fn) {
        return (Constructor)Executables.doFindMethod(fn);
    }

    public static <T1, T2, R> Constructor<R> findConstructor2(SerializableLambdas.SerializableFunction2<T1, T2, R> fn) {
        return (Constructor)Executables.doFindMethod(fn);
    }

    public static <T1, T2, T3, R> Constructor<R> findConstructor(SerializableLambdas.SerializableFunction3<T1, T2, T3, R> fn) {
        return (Constructor)Executables.doFindMethod(fn);
    }

    public static <T1, T2, T3, R> Constructor<R> findConstructor3(SerializableLambdas.SerializableFunction3<T1, T2, T3, R> fn) {
        return (Constructor)Executables.doFindMethod(fn);
    }

    public static <T1, T2, T3, T4, R> Constructor<R> findConstructor(SerializableLambdas.SerializableFunction4<T1, T2, T3, T4, R> fn) {
        return (Constructor)Executables.doFindMethod(fn);
    }

    public static <T1, T2, T3, T4, R> Constructor<R> findConstructor4(SerializableLambdas.SerializableFunction4<T1, T2, T3, T4, R> fn) {
        return (Constructor)Executables.doFindMethod(fn);
    }

    public static String findName(SerializableLambdas.SerializableLambda consumer) {
        return Executables.doFindMethodName(consumer);
    }

    public static String findMethodName(SerializableLambdas.SerializableConsumer0 consumer) {
        return Executables.doFindMethodName(consumer);
    }

    public static <T1> String findMethodName(SerializableLambdas.SerializableConsumer1<T1> consumer) {
        return Executables.doFindMethodName(consumer);
    }

    public static <T1, T2> String findMethodName(SerializableLambdas.SerializableConsumer2<T1, T2> consumer) {
        return Executables.doFindMethodName(consumer);
    }

    public static <T1, T2, T3> String findMethodName(SerializableLambdas.SerializableConsumer3<T1, T2, T3> consumer) {
        return Executables.doFindMethodName(consumer);
    }

    public static <T1, T2, T3, T4> String findMethodName(SerializableLambdas.SerializableConsumer4<T1, T2, T3, T4> consumer) {
        return Executables.doFindMethodName(consumer);
    }

    private static <E extends Executable> E doFindMethod(SerializableLambdas.SerializableLambda lambda) {
        Executable executable = Executables.runFinder(lambda, () -> {
            SerializedLambda serializedLambda = Executables.getSerializedLambda(lambda);
            String className = Utility.compactClassName(serializedLambda.getImplClass(), false);
            Class<?> clazz = Class.forName(className);
            Class<?>[] parameters = Executables.getParameters(serializedLambda.getImplMethodSignature());
            String implMethodName = serializedLambda.getImplMethodName();
            return "<init>".equals(implMethodName) ? clazz.getDeclaredConstructor(parameters) : clazz.getDeclaredMethod(implMethodName, parameters);
        });
        return (E)executable;
    }

    private static SerializedLambda getSerializedLambda(SerializableLambdas.SerializableLambda lambda) throws ReflectiveOperationException {
        SerializedLambda serializedLambda = null;
        for (Class<?> cl = lambda.getClass(); cl != null; cl = cl.getSuperclass()) {
            try {
                Method method = cl.getDeclaredMethod("writeReplace", new Class[0]);
                method.setAccessible(true);
                Object replacement = method.invoke((Object)lambda, new Object[0]);
                if (!(replacement instanceof SerializedLambda)) break;
                serializedLambda = (SerializedLambda)replacement;
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        if (serializedLambda == null) {
            throw new IllegalArgumentException("Cannot find SerializedLambda for " + lambda + " . Is it a lambda method reference or an object?");
        }
        return serializedLambda;
    }

    private static <T> T runFinder(SerializableLambdas.SerializableLambda lambda, Callable<T> finder) {
        try {
            return finder.call();
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot find method for " + lambda, e);
        }
    }

    private static String doFindMethodName(SerializableLambdas.SerializableLambda lambda) {
        return Executables.runFinder(lambda, () -> {
            SerializedLambda serializedLambda = Executables.getSerializedLambda(lambda);
            return serializedLambda.getImplMethodName();
        });
    }

    private static Class<?>[] getParameters(String signature) throws ClassNotFoundException {
        String[] params = Utility.methodSignatureArgumentTypes(signature, false);
        Class[] paramTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            Class<?> clazz;
            String className = params[i];
            paramTypes[i] = clazz = ClassUtils.forName(className, null);
        }
        return paramTypes;
    }

    private Executables() {
    }
}

