/*
 * Decompiled with CFR 0.152.
 */
package com.github.megatronking.stringfog.plugin;

import com.android.build.api.instrumentation.FramesComputationMode;
import com.android.build.api.instrumentation.InstrumentationScope;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.Variant;
import com.github.megatronking.stringfog.plugin.StringFogClassGenerator;
import com.github.megatronking.stringfog.plugin.StringFogExtension;
import com.github.megatronking.stringfog.plugin.StringFogMode;
import com.github.megatronking.stringfog.plugin.StringFogPlugin;
import com.github.megatronking.stringfog.plugin.StringFogTransform;
import groovy.util.Node;
import groovy.xml.XmlParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.configurationcache.extensions.CharSequenceExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J0\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/github/megatronking/stringfog/plugin/StringFogPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "generateStringFogClass", "applicationId", "", "buildDir", "Ljava/io/File;", "variant", "implementation", "mode", "Lcom/github/megatronking/stringfog/plugin/StringFogMode;", "Companion", "stringfog-gradle-plugin"})
public final class StringFogPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String PLUGIN_NAME = "stringfog";
    @NotNull
    private static final String FOG_CLASS_NAME = "StringFog";

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.getExtensions().create(PLUGIN_NAME, StringFogExtension.class, new Object[0]);
        AndroidComponentsExtension androidComponents = (AndroidComponentsExtension)project.getExtensions().getByType(AndroidComponentsExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)androidComponents, (String)"androidComponents");
        AndroidComponentsExtension.onVariants$default((AndroidComponentsExtension)androidComponents, null, (Function1)((Function1)new Function1<Variant, Unit>(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ StringFogPlugin this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Variant variant) {
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                StringFogExtension stringfog = (StringFogExtension)this.$project.getExtensions().getByType(StringFogExtension.class);
                CharSequence charSequence = stringfog.getImplementation();
                if (charSequence == null || charSequence.length() == 0) {
                    throw new IllegalArgumentException("Missing stringfog implementation config");
                }
                if (!stringfog.getEnable()) {
                    return;
                }
                File manifestFile = this.$project.file((Object)"src/main/AndroidManifest.xml");
                if (!manifestFile.exists()) {
                    throw new IllegalArgumentException("Missing file " + manifestFile);
                }
                Node parsedManifest = new XmlParser().parse((Reader)new InputStreamReader((InputStream)new FileInputStream(manifestFile), "utf-8"));
                if (!manifestFile.exists()) {
                    throw new IllegalArgumentException("Failed to parse file " + manifestFile);
                }
                Object object = parsedManifest.attribute((Object)"package");
                String applicationId = object != null ? object.toString() : null;
                CharSequence charSequence2 = applicationId;
                if (charSequence2 == null || charSequence2.length() == 0) {
                    throw new IllegalArgumentException("Unable to resolve applicationId");
                }
                this.$project.getTasks().getByName("preBuild").doLast(arg_0 -> apply.1.invoke$lambda$0((Function1)new Function1<Task, Unit>(variant, this.$project, this.this$0, applicationId, stringfog){
                    final /* synthetic */ Variant $variant;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ StringFogPlugin this$0;
                    final /* synthetic */ String $applicationId;
                    final /* synthetic */ StringFogExtension $stringfog;
                    {
                        this.$variant = $variant;
                        this.$project = $project;
                        this.this$0 = $receiver;
                        this.$applicationId = $applicationId;
                        this.$stringfog = $stringfog;
                        super(1);
                    }

                    public final void invoke(Task it) {
                        String variantName = CharSequenceExtensionsKt.capitalized((CharSequence)this.$variant.getName());
                        Set javaPreCompileTasks = this.$project.getTasksByName("generate" + variantName + "Resources", true);
                        if (javaPreCompileTasks.isEmpty()) {
                            throw new IllegalArgumentException("Unable to resolve task javaPreCompile" + variantName);
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)javaPreCompileTasks, (String)"javaPreCompileTasks");
                        ((Task)CollectionsKt.first((Iterable)javaPreCompileTasks)).doFirst(arg_0 -> apply.1.invoke$lambda$0((Function1)new Function1<Task, Unit>(this.this$0, this.$applicationId, this.$project, variantName, this.$stringfog){
                            final /* synthetic */ StringFogPlugin this$0;
                            final /* synthetic */ String $applicationId;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ String $variantName;
                            final /* synthetic */ StringFogExtension $stringfog;
                            {
                                this.this$0 = $receiver;
                                this.$applicationId = $applicationId;
                                this.$project = $project;
                                this.$variantName = $variantName;
                                this.$stringfog = $stringfog;
                                super(1);
                            }

                            public final void invoke(Task it) {
                                String string = this.$applicationId;
                                Intrinsics.checkNotNull((Object)string);
                                File file = this.$project.getBuildDir();
                                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
                                String string2 = this.$variantName.toLowerCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                                String string3 = this.$stringfog.getImplementation();
                                Intrinsics.checkNotNull((Object)string3);
                                StringFogPlugin.access$generateStringFogClass(this.this$0, string, file, string2, string3, this.$stringfog.getMode());
                            }
                        }, arg_0));
                    }

                    private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        $tmp0.invoke(p0);
                    }
                }, arg_0));
                File file = this.$project.getBuildDir();
                String string = variant.getName().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                File printFile = new File(file, "outputs/mapping/" + string + "/stringfog.txt");
                Intrinsics.checkNotNullExpressionValue((Object)stringfog, (String)"stringfog");
                StringFogTransform.Companion.setParameters(stringfog, printFile, applicationId + ".StringFog");
                variant.getInstrumentation().transformClassesWith(StringFogTransform.class, InstrumentationScope.PROJECT, (Function1)apply.2.INSTANCE);
                variant.getInstrumentation().setAsmFramesComputationMode(FramesComputationMode.COMPUTE_FRAMES_FOR_INSTRUMENTED_METHODS);
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }), (int)1, null);
    }

    private final void generateStringFogClass(String applicationId, File buildDir, String variant, String implementation, StringFogMode mode) {
        File stringfogDir = new File(buildDir, "generated" + File.separatorChar + "source" + File.separatorChar + "BuildConfig" + File.separatorChar + variant);
        File outputFile = new File(stringfogDir, StringsKt.replace$default((String)applicationId, (char)'.', (char)File.separatorChar, (boolean)false, (int)4, null) + File.separator + "StringFog.java");
        StringFogClassGenerator.generate((File)outputFile, (String)applicationId, (String)FOG_CLASS_NAME, (String)implementation, (StringFogMode)mode);
    }

    public static final /* synthetic */ void access$generateStringFogClass(StringFogPlugin $this, String applicationId, File buildDir, String variant, String implementation, StringFogMode mode) {
        $this.generateStringFogClass(applicationId, buildDir, variant, implementation, mode);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/github/megatronking/stringfog/plugin/StringFogPlugin$Companion;", "", "()V", "FOG_CLASS_NAME", "", "PLUGIN_NAME", "stringfog-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

