/*
 * Decompiled with CFR 0.152.
 */
package com.github.megatronking.stringfog;

import com.github.megatronking.stringfog.IStringFog;

public final class StringFogWrapper
implements IStringFog {
    private final IStringFog mStringFogImpl;

    public StringFogWrapper(String impl) {
        try {
            this.mStringFogImpl = (IStringFog)Class.forName(impl).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Stringfog implementation class not found: " + impl);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Stringfog implementation class new instance failed: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Stringfog implementation class access failed: " + e.getMessage());
        }
    }

    @Override
    public byte[] encrypt(String data, byte[] key) {
        return this.mStringFogImpl == null ? data.getBytes() : this.mStringFogImpl.encrypt(data, key);
    }

    @Override
    public String decrypt(byte[] data, byte[] key) {
        return this.mStringFogImpl == null ? new String(data) : this.mStringFogImpl.decrypt(data, key);
    }

    @Override
    public boolean shouldFog(String data) {
        return this.mStringFogImpl != null && this.mStringFogImpl.shouldFog(data);
    }
}

