/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.app.impl;

import io.nadron.app.Player;
import io.nadron.app.PlayerSession;
import java.util.HashSet;
import java.util.Set;

public class DefaultPlayer
implements Player {
    private Object id;
    private String name;
    private String emailId;
    private Set<PlayerSession> playerSessions;

    public DefaultPlayer() {
        this.playerSessions = new HashSet<PlayerSession>();
    }

    public DefaultPlayer(Object id, String name, String emailId) {
        this.id = id;
        this.name = name;
        this.emailId = emailId;
        this.playerSessions = new HashSet<PlayerSession>();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultPlayer other = (DefaultPlayer)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public void setId(Object id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getEmailId() {
        return this.emailId;
    }

    @Override
    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    @Override
    public synchronized boolean addSession(PlayerSession session) {
        return this.playerSessions.add(session);
    }

    @Override
    public synchronized boolean removeSession(PlayerSession session) {
        boolean remove = this.playerSessions.remove(session);
        if (this.playerSessions.size() == 0) {
            this.logout(session);
        }
        return remove;
    }

    @Override
    public synchronized void logout(PlayerSession session) {
        session.close();
        if (null != this.playerSessions) {
            this.playerSessions.remove(session);
        }
    }

    public Set<PlayerSession> getPlayerSessions() {
        return this.playerSessions;
    }

    public void setPlayerSessions(Set<PlayerSession> playerSessions) {
        this.playerSessions = playerSessions;
    }
}

