/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.app.impl;

import io.nadron.app.GameRoom;
import io.nadron.app.Player;
import io.nadron.app.PlayerSession;
import io.nadron.app.impl.DefaultSession;
import io.nadron.concurrent.LaneStrategy;
import io.nadron.event.Event;
import io.nadron.event.impl.EventDispatchers;
import io.nadron.protocols.Protocol;

public class DefaultPlayerSession
extends DefaultSession
implements PlayerSession {
    protected final Player player;
    protected GameRoom parentGameRoom;
    protected Protocol protocol;

    protected DefaultPlayerSession(PlayerSessionBuilder playerSessionBuilder) {
        super(playerSessionBuilder);
        this.player = playerSessionBuilder.player;
        this.parentGameRoom = playerSessionBuilder.parentGameRoom;
        this.protocol = playerSessionBuilder.protocol;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public GameRoom getGameRoom() {
        return this.parentGameRoom;
    }

    @Override
    public void setGameRoom(GameRoom gameRoom) {
        this.parentGameRoom = gameRoom;
    }

    @Override
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public synchronized void close() {
        if (!this.isShuttingDown) {
            super.close();
            this.parentGameRoom.disconnectSession(this);
        }
    }

    @Override
    public void sendToGameRoom(Event event) {
        this.parentGameRoom.send(event);
    }

    public String toString() {
        return "PlayerSession [id=" + this.id + "player=" + this.player + ", parentGameRoom=" + this.parentGameRoom + ", protocol=" + this.protocol + ", isShuttingDown=" + this.isShuttingDown + "]";
    }

    public static class PlayerSessionBuilder
    extends DefaultSession.SessionBuilder {
        protected Player player = null;
        protected GameRoom parentGameRoom;
        protected Protocol protocol;

        @Override
        public PlayerSession build() {
            return new DefaultPlayerSession(this);
        }

        public PlayerSessionBuilder player(Player player) {
            this.player = player;
            return this;
        }

        public PlayerSessionBuilder parentGameRoom(GameRoom parentGameRoom) {
            if (null == parentGameRoom) {
                throw new IllegalArgumentException("GameRoom instance is null, session will not be constructed");
            }
            this.parentGameRoom = parentGameRoom;
            return this;
        }

        @Override
        protected void validateAndSetValues() {
            if (null == this.eventDispatcher) {
                this.eventDispatcher = EventDispatchers.newJetlangEventDispatcher(this.parentGameRoom, LaneStrategy.LaneStrategies.GROUP_BY_ROOM);
            }
            super.validateAndSetValues();
        }

        public PlayerSessionBuilder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }
    }
}

