/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.app.impl;

import io.nadron.app.Session;
import io.nadron.communication.MessageSender;
import io.nadron.event.Event;
import io.nadron.event.EventDispatcher;
import io.nadron.event.EventHandler;
import io.nadron.event.impl.EventDispatchers;
import io.nadron.service.UniqueIDGeneratorService;
import io.nadron.service.impl.SimpleUniqueIdGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultSession
implements Session {
    protected final Object id;
    protected EventDispatcher eventDispatcher;
    protected final Map<String, Object> sessionAttributes;
    protected final long creationTime;
    protected long lastReadWriteTime;
    protected Session.Status status;
    protected boolean isWriteable;
    protected volatile boolean isShuttingDown;
    protected boolean isUDPEnabled;
    protected MessageSender.Reliable tcpSender = null;
    protected MessageSender.Fast udpSender = null;

    protected DefaultSession(SessionBuilder sessionBuilder) {
        sessionBuilder.validateAndSetValues();
        this.id = sessionBuilder.id;
        this.eventDispatcher = sessionBuilder.eventDispatcher;
        this.sessionAttributes = sessionBuilder.sessionAttributes;
        this.creationTime = sessionBuilder.creationTime;
        this.status = sessionBuilder.status;
        this.lastReadWriteTime = sessionBuilder.lastReadWriteTime;
        this.isWriteable = sessionBuilder.isWriteable;
        this.isShuttingDown = sessionBuilder.isShuttingDown;
        this.isUDPEnabled = sessionBuilder.isUDPEnabled;
    }

    @Override
    public void onEvent(Event event) {
        if (!this.isShuttingDown) {
            this.eventDispatcher.fireEvent(event);
        }
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public void setId(Object id) {
        throw new IllegalArgumentException("id cannot be set in this implementation, since it is final");
    }

    @Override
    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    @Override
    public void addHandler(EventHandler eventHandler) {
        this.eventDispatcher.addHandler(eventHandler);
    }

    @Override
    public void removeHandler(EventHandler eventHandler) {
        this.eventDispatcher.removeHandler(eventHandler);
    }

    @Override
    public List<EventHandler> getEventHandlers(int eventType) {
        return this.eventDispatcher.getHandlers(eventType);
    }

    @Override
    public Object getAttribute(String key) {
        return this.sessionAttributes.get(key);
    }

    @Override
    public void removeAttribute(String key) {
        this.sessionAttributes.remove(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.sessionAttributes.put(key, value);
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getLastReadWriteTime() {
        return this.lastReadWriteTime;
    }

    public void setLastReadWriteTime(long lastReadWriteTime) {
        this.lastReadWriteTime = lastReadWriteTime;
    }

    @Override
    public Session.Status getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(Session.Status status) {
        this.status = status;
    }

    @Override
    public boolean isConnected() {
        return this.status == Session.Status.CONNECTED;
    }

    @Override
    public boolean isWriteable() {
        return this.isWriteable;
    }

    @Override
    public void setWriteable(boolean isWriteable) {
        this.isWriteable = isWriteable;
    }

    @Override
    public boolean isUDPEnabled() {
        return this.isUDPEnabled;
    }

    @Override
    public void setUDPEnabled(boolean isEnabled) {
        this.isUDPEnabled = isEnabled;
    }

    @Override
    public synchronized void close() {
        this.isShuttingDown = true;
        this.eventDispatcher.close();
        if (null != this.tcpSender) {
            this.tcpSender.close();
            this.tcpSender = null;
        }
        if (null != this.udpSender) {
            this.udpSender.close();
            this.udpSender = null;
        }
        this.status = Session.Status.CLOSED;
    }

    @Override
    public boolean isShuttingDown() {
        return this.isShuttingDown;
    }

    public Map<String, Object> getSessionAttributes() {
        return this.sessionAttributes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultSession other = (DefaultSession)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public MessageSender.Reliable getTcpSender() {
        return this.tcpSender;
    }

    @Override
    public void setTcpSender(MessageSender.Reliable tcpSender) {
        this.tcpSender = tcpSender;
    }

    @Override
    public MessageSender.Fast getUdpSender() {
        return this.udpSender;
    }

    @Override
    public void setUdpSender(MessageSender.Fast udpSender) {
        this.udpSender = udpSender;
    }

    public static class SessionBuilder {
        protected static final UniqueIDGeneratorService ID_GENERATOR_SERVICE = new SimpleUniqueIdGenerator();
        protected Object id = null;
        protected EventDispatcher eventDispatcher = null;
        protected Map<String, Object> sessionAttributes = null;
        protected long creationTime = 0L;
        protected long lastReadWriteTime = 0L;
        protected Session.Status status = Session.Status.NOT_CONNECTED;
        protected boolean isWriteable = true;
        protected volatile boolean isShuttingDown = false;
        protected boolean isUDPEnabled = false;

        public Session build() {
            return new DefaultSession(this);
        }

        protected void validateAndSetValues() {
            if (null == this.id) {
                this.id = String.valueOf(ID_GENERATOR_SERVICE.generateFor(DefaultSession.class));
            }
            if (null == this.eventDispatcher) {
                this.eventDispatcher = EventDispatchers.newJetlangEventDispatcher(null, null);
            }
            if (null == this.sessionAttributes) {
                this.sessionAttributes = new HashMap<String, Object>();
            }
            this.creationTime = System.currentTimeMillis();
        }

        public Object getId() {
            return this.id;
        }

        public SessionBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SessionBuilder eventDispatcher(EventDispatcher eventDispatcher) {
            this.eventDispatcher = eventDispatcher;
            return this;
        }

        public SessionBuilder sessionAttributes(Map<String, Object> sessionAttributes) {
            this.sessionAttributes = sessionAttributes;
            return this;
        }

        public SessionBuilder creationTime(long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public SessionBuilder lastReadWriteTime(long lastReadWriteTime) {
            this.lastReadWriteTime = lastReadWriteTime;
            return this;
        }

        public SessionBuilder status(Session.Status status) {
            this.status = status;
            return this;
        }

        public SessionBuilder isWriteable(boolean isWriteable) {
            this.isWriteable = isWriteable;
            return this;
        }

        public SessionBuilder isShuttingDown(boolean isShuttingDown) {
            this.isShuttingDown = isShuttingDown;
            return this;
        }

        public SessionBuilder isUDPEnabled(boolean isUDPEnabled) {
            this.isUDPEnabled = isUDPEnabled;
            return this;
        }
    }
}

