/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.app.impl;

import io.nadron.app.Game;
import io.nadron.app.GameRoom;
import io.nadron.app.Player;
import io.nadron.app.PlayerSession;
import io.nadron.app.Session;
import io.nadron.app.SessionFactory;
import io.nadron.app.impl.DefaultSession;
import io.nadron.app.impl.Sessions;
import io.nadron.concurrent.LaneStrategy;
import io.nadron.event.Event;
import io.nadron.event.Events;
import io.nadron.event.NetworkEvent;
import io.nadron.event.impl.EventDispatchers;
import io.nadron.event.impl.NetworkEventListener;
import io.nadron.protocols.Protocol;
import io.nadron.service.GameStateManagerService;
import io.nadron.service.impl.GameStateManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GameRoomSession
extends DefaultSession
implements GameRoom {
    private static final Logger LOG = LoggerFactory.getLogger(GameRoomSession.class);
    protected String gameRoomName;
    protected Game parentGame;
    protected GameStateManagerService stateManager;
    protected Set<PlayerSession> sessions;
    protected Protocol protocol;
    protected SessionFactory sessionFactory;

    protected GameRoomSession(GameRoomSessionBuilder gameRoomSessionBuilder) {
        super(gameRoomSessionBuilder);
        this.sessions = gameRoomSessionBuilder.sessions;
        this.parentGame = gameRoomSessionBuilder.parentGame;
        this.gameRoomName = gameRoomSessionBuilder.gameRoomName;
        this.protocol = gameRoomSessionBuilder.protocol;
        this.stateManager = gameRoomSessionBuilder.stateManager;
        this.sessionFactory = gameRoomSessionBuilder.sessionFactory;
        if (null == gameRoomSessionBuilder.eventDispatcher) {
            this.eventDispatcher = EventDispatchers.newJetlangEventDispatcher(this, gameRoomSessionBuilder.laneStrategy);
        }
    }

    @Override
    public PlayerSession createPlayerSession(Player player) {
        PlayerSession playerSession = this.getSessionInstance(player);
        return playerSession;
    }

    @Override
    public abstract void onLogin(PlayerSession var1);

    @Override
    public synchronized boolean connectSession(PlayerSession playerSession) {
        if (!this.isShuttingDown) {
            playerSession.setStatus(Session.Status.CONNECTING);
            this.sessions.add(playerSession);
            playerSession.setGameRoom(this);
            LOG.trace("Protocol to be applied is: {}", (Object)this.protocol.getClass().getName());
            this.protocol.applyProtocol(playerSession, true);
            this.createAndAddEventHandlers(playerSession);
            playerSession.setStatus(Session.Status.CONNECTED);
            this.afterSessionConnect(playerSession);
            return true;
        }
        LOG.warn("Game Room is shutting down, playerSession {} {}", (Object)playerSession, (Object)"will not be connected!");
        return false;
    }

    @Override
    public void afterSessionConnect(PlayerSession playerSession) {
        Object state;
        GameStateManagerService manager = this.getStateManager();
        if (null != manager && null != (state = manager.getState())) {
            playerSession.onEvent(Events.networkEvent(state));
        }
    }

    @Override
    public synchronized boolean disconnectSession(PlayerSession playerSession) {
        boolean removeHandlers = this.eventDispatcher.removeHandlersForSession(playerSession);
        return removeHandlers && this.sessions.remove(playerSession);
    }

    @Override
    public void send(Event event) {
        this.onEvent(event);
    }

    @Override
    public void sendBroadcast(NetworkEvent networkEvent) {
        this.onEvent(networkEvent);
    }

    @Override
    public synchronized void close() {
        this.isShuttingDown = true;
        for (PlayerSession session : this.sessions) {
            session.close();
        }
    }

    public PlayerSession getSessionInstance(Player player) {
        PlayerSession playerSession = this.sessionFactory.newPlayerSession(this, player);
        return playerSession;
    }

    @Override
    public Set<PlayerSession> getSessions() {
        return this.sessions;
    }

    @Override
    public void setSessions(Set<PlayerSession> sessions) {
        this.sessions = sessions;
    }

    @Override
    public String getGameRoomName() {
        return this.gameRoomName;
    }

    @Override
    public void setGameRoomName(String gameRoomName) {
        this.gameRoomName = gameRoomName;
    }

    @Override
    public Game getParentGame() {
        return this.parentGame;
    }

    @Override
    public void setParentGame(Game parentGame) {
        this.parentGame = parentGame;
    }

    @Override
    public void setStateManager(GameStateManagerService stateManager) {
        this.stateManager = stateManager;
    }

    @Override
    public GameStateManagerService getStateManager() {
        return this.stateManager;
    }

    @Override
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public SessionFactory getFactory() {
        return this.sessionFactory;
    }

    @Override
    public void setFactory(SessionFactory factory) {
        this.sessionFactory = factory;
    }

    @Override
    public boolean isShuttingDown() {
        return this.isShuttingDown;
    }

    public void setShuttingDown(boolean isShuttingDown) {
        this.isShuttingDown = isShuttingDown;
    }

    protected void createAndAddEventHandlers(PlayerSession playerSession) {
        NetworkEventListener networkEventHandler = new NetworkEventListener(playerSession);
        this.eventDispatcher.addHandler(networkEventHandler);
        LOG.trace("Added Network handler to EventDispatcher of GameRoom {}, for session: {}", (Object)this, (Object)playerSession);
    }

    public static class GameRoomSessionBuilder
    extends DefaultSession.SessionBuilder {
        protected Set<PlayerSession> sessions;
        protected Game parentGame;
        protected String gameRoomName;
        protected Protocol protocol;
        protected LaneStrategy<String, ExecutorService, GameRoom> laneStrategy;
        protected GameStateManagerService stateManager;
        protected SessionFactory sessionFactory;

        @Override
        protected void validateAndSetValues() {
            if (null == this.id) {
                this.id = String.valueOf(ID_GENERATOR_SERVICE.generateFor(GameRoomSession.class));
            }
            if (null == this.sessionAttributes) {
                this.sessionAttributes = new HashMap();
            }
            if (null == this.sessions) {
                this.sessions = new HashSet<PlayerSession>();
            }
            if (null == this.laneStrategy) {
                this.laneStrategy = LaneStrategy.LaneStrategies.GROUP_BY_ROOM;
            }
            if (null == this.stateManager) {
                this.stateManager = new GameStateManager();
            }
            if (null == this.sessionFactory) {
                this.sessionFactory = Sessions.INSTANCE;
            }
            this.creationTime = System.currentTimeMillis();
        }

        public GameRoomSessionBuilder sessions(Set<PlayerSession> sessions) {
            this.sessions = sessions;
            return this;
        }

        public GameRoomSessionBuilder parentGame(Game parentGame) {
            this.parentGame = parentGame;
            return this;
        }

        public GameRoomSessionBuilder gameRoomName(String gameRoomName) {
            this.gameRoomName = gameRoomName;
            return this;
        }

        public GameRoomSessionBuilder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public GameRoomSessionBuilder laneStrategy(LaneStrategy<String, ExecutorService, GameRoom> laneStrategy) {
            this.laneStrategy = laneStrategy;
            return this;
        }

        public GameRoomSessionBuilder stateManager(GameStateManagerService gameStateManagerService) {
            this.stateManager = gameStateManagerService;
            return this;
        }

        public GameRoomSessionBuilder sessionFactory(SessionFactory sessionFactory) {
            this.sessionFactory = sessionFactory;
            return this;
        }
    }
}

