/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.communication;

import io.nadron.communication.MessageBuffer;
import io.nadron.convert.Transform;
import io.nadron.util.NettyUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

public class NettyMessageBuffer
implements MessageBuffer<ByteBuf> {
    private final ByteBuf buffer;

    public NettyMessageBuffer() {
        this.buffer = Unpooled.buffer();
    }

    public NettyMessageBuffer(ByteBuf buffer) {
        this.buffer = buffer;
    }

    @Override
    public boolean isReadable() {
        return this.buffer.isReadable();
    }

    @Override
    public int readableBytes() {
        return this.buffer.readableBytes();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public void clear() {
        this.buffer.clear();
    }

    @Override
    public ByteBuf getNativeBuffer() {
        return this.buffer;
    }

    @Override
    public int readByte() {
        return this.buffer.readByte();
    }

    @Override
    public int readUnsignedByte() {
        return this.buffer.readUnsignedByte();
    }

    @Override
    public byte[] readBytes(int length) {
        byte[] bytes = new byte[length];
        this.buffer.readBytes(bytes);
        return bytes;
    }

    @Override
    public void readBytes(byte[] dst) {
        this.buffer.readBytes(dst);
    }

    @Override
    public void readBytes(byte[] dst, int dstIndex, int length) {
        this.buffer.readBytes(dst, dstIndex, length);
    }

    @Override
    public char readChar() {
        return this.buffer.readChar();
    }

    @Override
    public int readUnsignedShort() {
        return this.buffer.readUnsignedShort();
    }

    @Override
    public int readShort() {
        return this.buffer.readShort();
    }

    @Override
    public int readUnsignedMedium() {
        return this.buffer.readUnsignedMedium();
    }

    @Override
    public int readMedium() {
        return this.buffer.readMedium();
    }

    @Override
    public long readUnsignedInt() {
        return this.buffer.readUnsignedInt();
    }

    @Override
    public int readInt() {
        return this.buffer.readInt();
    }

    @Override
    public long readLong() {
        return this.buffer.readLong();
    }

    @Override
    public float readFloat() {
        return this.buffer.readFloat();
    }

    @Override
    public double readDouble() {
        return this.buffer.readChar();
    }

    @Override
    public String readString() {
        return NettyUtils.readString(this.buffer);
    }

    @Override
    public String[] readStrings(int numOfStrings) {
        return NettyUtils.readStrings(this.buffer, numOfStrings);
    }

    @Override
    public <V> V readObject(Transform<ByteBuf, V> converter) {
        return NettyUtils.readObject(this.buffer, converter);
    }

    @Override
    public MessageBuffer<ByteBuf> writeByte(byte b) {
        this.buffer.writeByte((int)b);
        return this;
    }

    @Override
    public MessageBuffer<ByteBuf> writeBytes(byte[] src) {
        this.buffer.writeBytes(src);
        return this;
    }

    @Override
    public MessageBuffer<ByteBuf> writeChar(int value) {
        this.buffer.writeChar(value);
        return this;
    }

    @Override
    public MessageBuffer<ByteBuf> writeShort(int value) {
        this.buffer.writeShort(value);
        return this;
    }

    @Override
    public MessageBuffer<ByteBuf> writeMedium(int value) {
        this.buffer.writeMedium(value);
        return this;
    }

    @Override
    public MessageBuffer<ByteBuf> writeInt(int value) {
        this.buffer.writeInt(value);
        return this;
    }

    @Override
    public MessageBuffer<ByteBuf> writeLong(long value) {
        this.buffer.writeLong(value);
        return this;
    }

    @Override
    public MessageBuffer<ByteBuf> writeFloat(float value) {
        this.buffer.writeFloat(value);
        return this;
    }

    @Override
    public MessageBuffer<ByteBuf> writeDouble(double value) {
        this.buffer.writeDouble(value);
        return this;
    }

    @Override
    public MessageBuffer<ByteBuf> writeString(String message) {
        ByteBuf strBuf = NettyUtils.writeString(message);
        this.buffer.writeBytes(strBuf);
        return this;
    }

    @Override
    public MessageBuffer<ByteBuf> writeStrings(String ... messages) {
        ByteBuf strMultiBuf = NettyUtils.writeStrings(messages);
        this.buffer.writeBytes(strMultiBuf);
        return this;
    }

    @Override
    public <V> MessageBuffer<ByteBuf> writeObject(Transform<V, ByteBuf> converter, V object) {
        ByteBuf objBuf = NettyUtils.writeObject(converter, object);
        this.buffer.writeBytes(objBuf);
        return this;
    }
}

