/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.communication;

import io.nadron.communication.DeliveryGuaranty;
import io.nadron.communication.MessageSender;
import io.nadron.event.Event;
import io.nadron.event.Events;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyTCPMessageSender
implements MessageSender.Reliable {
    private final Channel channel;
    private static final DeliveryGuaranty DELIVERY_GUARANTY = DeliveryGuaranty.DeliveryGuarantyOptions.RELIABLE;
    private static final Logger LOG = LoggerFactory.getLogger(NettyTCPMessageSender.class);

    public NettyTCPMessageSender(Channel channel) {
        this.channel = channel;
    }

    @Override
    public Object sendMessage(Object message) {
        return this.channel.writeAndFlush(message);
    }

    @Override
    public DeliveryGuaranty getDeliveryGuaranty() {
        return DELIVERY_GUARANTY;
    }

    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public void close() {
        LOG.debug("Going to close tcp connection in class: {}", (Object)this.getClass().getName());
        Event event = Events.event(null, 34);
        if (this.channel.isActive()) {
            this.channel.write((Object)event).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            this.channel.close();
            LOG.trace("Unable to write the Event {} with type {} to socket", (Object)event, (Object)event.getType());
        }
    }

    public String toString() {
        String channelId = "TCP channel: ";
        channelId = null != this.channel ? channelId + this.channel.toString() : channelId + "0";
        String sender = "Netty " + channelId;
        return sender;
    }
}

