/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.communication;

import io.nadron.app.Session;
import io.nadron.communication.DeliveryGuaranty;
import io.nadron.communication.MessageSender;
import io.nadron.event.Event;
import io.nadron.event.EventContext;
import io.nadron.service.SessionRegistryService;
import io.netty.channel.socket.DatagramChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyUDPMessageSender
implements MessageSender.Fast {
    private static final Logger LOG = LoggerFactory.getLogger(NettyUDPMessageSender.class);
    private final SocketAddress remoteAddress;
    private final DatagramChannel channel;
    private final SessionRegistryService<SocketAddress> sessionRegistryService;
    private final EventContext eventContext;
    private static final DeliveryGuaranty DELIVERY_GUARANTY = DeliveryGuaranty.DeliveryGuarantyOptions.FAST;

    public NettyUDPMessageSender(SocketAddress remoteAddress, DatagramChannel channel, SessionRegistryService<SocketAddress> sessionRegistryService) {
        this.remoteAddress = remoteAddress;
        this.channel = channel;
        this.sessionRegistryService = sessionRegistryService;
        this.eventContext = new EventContextImpl((InetSocketAddress)remoteAddress);
    }

    @Override
    public Object sendMessage(Object message) {
        if (message instanceof Event) {
            ((Event)message).setEventContext(this.eventContext);
        }
        return this.channel.writeAndFlush(message);
    }

    @Override
    public DeliveryGuaranty getDeliveryGuaranty() {
        return DELIVERY_GUARANTY;
    }

    @Override
    public void close() {
        Session session = this.sessionRegistryService.getSession(this.remoteAddress);
        if (this.sessionRegistryService.removeSession(this.remoteAddress)) {
            LOG.debug("Successfully removed session: {}", (Object)session);
        } else {
            LOG.trace("No udp session found for address: {}", (Object)this.remoteAddress);
        }
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public DatagramChannel getChannel() {
        return this.channel;
    }

    public String toString() {
        String channelId = "UDP Channel: ";
        channelId = null != this.channel ? channelId + this.channel.toString() : channelId + "0";
        String sender = "Netty " + channelId + " RemoteAddress: " + this.remoteAddress;
        return sender;
    }

    protected SessionRegistryService<SocketAddress> getSessionRegistryService() {
        return this.sessionRegistryService;
    }

    protected static class EventContextImpl
    implements EventContext {
        final InetSocketAddress clientAddress;

        public EventContextImpl(InetSocketAddress clientAddress) {
            this.clientAddress = clientAddress;
        }

        @Override
        public Session getSession() {
            return null;
        }

        @Override
        public void setSession(Session session) {
        }

        @Override
        public InetSocketAddress getAttachment() {
            return this.clientAddress;
        }

        @Override
        public void setAttachment(Object attachement) {
        }
    }
}

