/*
 * Decompiled with CFR 0.152.
 */
package io.nadron.concurrent;

import io.nadron.concurrent.Lane;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetlang.fibers.Fiber;
import org.jetlang.fibers.PoolFiberFactory;
import org.jetlang.fibers.ThreadFiber;

public class Fibers {
    private static final ExecutorService SERVICE;
    private static final PoolFiberFactory FACT;
    private static final ConcurrentHashMap<Lane<String, ExecutorService>, PoolFiberFactory> lanePoolFactoryMap;

    public static Fiber pooledFiber() {
        Fiber fiber = FACT.create();
        fiber.start();
        return fiber;
    }

    public static Fiber pooledFiber(Lane<String, ExecutorService> lane) {
        if (null == lanePoolFactoryMap.get(lane)) {
            lanePoolFactoryMap.putIfAbsent(lane, new PoolFiberFactory((Executor)lane.getUnderlyingLane()));
        }
        Fiber fiber = lanePoolFactoryMap.get(lane).create();
        fiber.start();
        return fiber;
    }

    public static Fiber threadFiber() {
        ThreadFiber fiber = new ThreadFiber();
        fiber.start();
        return fiber;
    }

    static {
        lanePoolFactoryMap = new ConcurrentHashMap();
        SERVICE = Executors.newSingleThreadExecutor();
        FACT = new PoolFiberFactory((Executor)SERVICE);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                SERVICE.shutdown();
            }
        });
    }
}

